/*      */ package org.jboss.aop.instrument;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javassist.CannotCompileException;
/*      */ import javassist.ClassPool;
/*      */ import javassist.CodeConverter;
/*      */ import javassist.CodeConverter.DefaultArrayAccessReplacementMethodNames;
/*      */ import javassist.CtClass;
/*      */ import javassist.CtConstructor;
/*      */ import javassist.CtField;
/*      */ import javassist.CtField.Initializer;
/*      */ import javassist.CtMethod;
/*      */ import javassist.CtMethod.ConstParameter;
/*      */ import javassist.CtNewMethod;
/*      */ import javassist.NotFoundException;
/*      */ import javassist.SerialVersionUID;
/*      */ import javassist.bytecode.AnnotationsAttribute;
/*      */ import javassist.bytecode.ClassFile;
/*      */ import javassist.bytecode.FieldInfo;
/*      */ import javassist.bytecode.MethodInfo;
/*      */ import javassist.bytecode.annotation.Annotation;
/*      */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*      */ import org.jboss.aop.Advised;
/*      */ import org.jboss.aop.Advisor;
/*      */ import org.jboss.aop.AspectManager;
/*      */ import org.jboss.aop.ClassAdvisor;
/*      */ import org.jboss.aop.InterceptionMarkers;
/*      */ import org.jboss.aop.annotation.AnnotationRepository;
/*      */ import org.jboss.aop.annotation.compiler.AnnotationInfoCreator;
/*      */ import org.jboss.aop.array.ArrayAdvisor;
/*      */ import org.jboss.aop.array.ArrayReplacement;
/*      */ import org.jboss.aop.classpool.AOPClassPool;
/*      */ import org.jboss.aop.classpool.AOPClassPoolRepository;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*      */ import org.jboss.aop.util.Advisable;
/*      */ import org.jboss.aop.util.CtConstructorComparator;
/*      */ import org.jboss.aop.util.CtFieldComparator;
/*      */ import org.jboss.aop.util.JavassistMethodHashing;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public abstract class Instrumentor
/*      */ {
/*   85 */   private static final Logger logger = AOPLogger.getLogger(Instrumentor.class);
/*      */ 
/*   90 */   public static final String AOP_PACKAGE = Advised.class.getPackage().getName();
/*      */ 
/*   96 */   public static final String ASPECT_MANAGER_CLASS_NAME = AOP_PACKAGE + ".AspectManager";
/*      */   public static final String HELPER_FIELD_NAME = "aop$classAdvisor$aop";
/*      */   protected AOPClassPool classPool;
/*  105 */   protected boolean basicsSet = false;
/*      */   protected CodeConverter converter;
/*      */   protected AspectManager manager;
/*      */   protected JoinpointClassifier joinpointClassifier;
/*  111 */   protected static Collection processedClasses = new ArrayList();
/*      */   MethodExecutionTransformer methodExecutionTransformer;
/*      */   ConstructorExecutionTransformer constructorExecutionTransformer;
/*      */   ConstructionTransformer constructionTransformer;
/*      */   FieldAccessTransformer fieldAccessTransformer;
/*      */   CallerTransformer callerTransformer;
/*      */   DynamicTransformationObserver dynamicTransformationObserver;
/*      */ 
/*      */   protected Instrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer)
/*      */   {
/*  132 */     this.classPool = pool;
/*  133 */     this.converter = new CodeConverter();
/*  134 */     this.manager = manager;
/*  135 */     this.joinpointClassifier = joinpointClassifier;
/*  136 */     this.dynamicTransformationObserver = observer;
/*  137 */     intitialiseTransformers();
/*      */   }
/*      */ 
/*      */   protected Instrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier)
/*      */   {
/*  143 */     this(null, manager, joinpointClassifier, null);
/*      */   }
/*      */ 
/*      */   protected abstract void intitialiseTransformers();
/*      */ 
/*      */   public ClassPool getClassPool()
/*      */   {
/*  153 */     return this.classPool;
/*      */   }
/*      */ 
/*      */   CodeConverter getCodeConverter()
/*      */   {
/*  158 */     return this.converter;
/*      */   }
/*      */ 
/*      */   public boolean isAdvised(CtClass clazz) throws NotFoundException
/*      */   {
/*  163 */     CtClass[] interfaces = clazz.getInterfaces();
/*  164 */     CtClass advised = forName(AOP_PACKAGE + ".Advised");
/*  165 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  167 */       if (interfaces[i].equals(advised)) return true;
/*  168 */       if (interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) return true;
/*      */     }
/*  170 */     return false;
/*      */   }
/*      */ 
/*      */   public static boolean implementsAdvised(CtClass clazz) throws NotFoundException
/*      */   {
/*  175 */     CtClass[] interfaces = clazz.getInterfaces();
/*  176 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  178 */       if (interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) return true;
/*      */     }
/*  180 */     return false;
/*      */   }
/*      */ 
/*      */   public static boolean isTransformable(CtClass clazz)
/*      */     throws NotFoundException
/*      */   {
/*  186 */     CtClass[] interfaces = clazz.getInterfaces();
/*      */ 
/*  188 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  191 */       if (interfaces[i].getName().equals(AOP_PACKAGE + ".instrument.Untransformable")) return false;
/*      */     }
/*  193 */     return true;
/*      */   }
/*      */ 
/*      */   protected boolean isBaseClass(CtClass clazz)
/*      */     throws NotFoundException
/*      */   {
/*  199 */     if (clazz.getSuperclass() != null)
/*      */     {
/*  201 */       return !isAdvised(clazz.getSuperclass());
/*      */     }
/*  203 */     return true;
/*      */   }
/*      */ 
/*      */   protected static String mixinFieldName(CtClass mixinClass)
/*      */   {
/*  209 */     StringBuffer buf = new StringBuffer("_");
/*  210 */     buf.append(mixinClass.getName().replace('.', '$'));
/*  211 */     buf.append("$aop$mixin");
/*  212 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   private void addMixinMethod(Advisor advisor, CtMethod method, CtClass clazz, CtMethod delegate, long hash) throws Exception
/*      */   {
/*  217 */     CtClass[] exceptions = method.getExceptionTypes();
/*      */ 
/*  220 */     CtMethod newMethod = CtNewMethod.wrapped(method.getReturnType(), method.getName(), method.getParameterTypes(), exceptions, delegate, CtMethod.ConstParameter.integer(hash), clazz);
/*      */ 
/*  227 */     newMethod.setModifiers(1);
/*  228 */     clazz.addMethod(newMethod);
/*      */   }
/*      */ 
/*      */   private void addMixin(CtClass clazz, InterfaceIntroduction pointcut, InterfaceIntroduction.Mixin mixin, HashMap baseMethods)
/*      */     throws Exception
/*      */   {
/*  239 */     CtClass mixinClass = this.classPool.get(mixin.getClassName());
/*      */ 
/*  242 */     if (pointcut.getConstructorClass() != null)
/*      */     {
/*  244 */       CtClass type = forName(pointcut.getConstructorClass());
/*  245 */       CtMethod[] methods = type.getDeclaredMethods();
/*  246 */       boolean correct = false;
/*  247 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  249 */         if ((!methods[i].getName().equals(pointcut.getConstructorMethod())) || (methods[i].getParameterTypes().length != 1)) {
/*      */           continue;
/*      */         }
/*  252 */         if (!clazz.subclassOf(methods[i].getParameterTypes()[0]))
/*      */           continue;
/*  254 */         correct = true;
/*      */       }
/*      */ 
/*  259 */       if (!correct)
/*      */       {
/*  261 */         throw new RuntimeException("Could not find a method named '" + pointcut.getConstructorMethod() + "' on class " + pointcut.getConstructorClass() + " that receives " + clazz.getName() + " or one of its superclasses as parameter.");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  268 */     String initializer = null;
/*  269 */     if (mixin.getConstruction() == null)
/*      */     {
/*  271 */       if (mixinClass.getConstructor("()V") == null)
/*      */       {
/*  273 */         throw new RuntimeException("Default constructor of mixin class '" + mixinClass + "' not found.");
/*      */       }
/*      */ 
/*  276 */       initializer = "new " + mixinClass.getName() + "()";
/*      */     }
/*      */     else
/*      */     {
/*  280 */       initializer = mixin.getConstruction();
/*      */     }
/*  282 */     CtClass type = forName(mixinClass.getName());
/*  283 */     CtField field = new CtField(type, mixinFieldName(mixinClass), clazz);
/*  284 */     int modifiers = 2;
/*  285 */     if (mixin.isTransient()) modifiers |= 128;
/*  286 */     field.setModifiers(modifiers);
/*  287 */     clazz.addField(field, CtField.Initializer.byExpr(initializer));
/*  288 */     HashSet addedMethods = new HashSet();
/*      */ 
/*  290 */     String[] interfaces = mixin.getInterfaces();
/*  291 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  293 */       CtClass intf = this.classPool.get(interfaces[i]);
/*  294 */       if (!clazz.subtypeOf(intf)) {
/*  295 */         clazz.addInterface(intf);
/*  296 */         HashMap intfMap = JavassistMethodHashing.getMethodMap(intf);
/*  297 */         Iterator entries = intfMap.entrySet().iterator();
/*  298 */         while (entries.hasNext())
/*      */         {
/*  300 */           Map.Entry entry = (Map.Entry)entries.next();
/*  301 */           Long hash = (Long)entry.getKey();
/*  302 */           CtMethod method = (CtMethod)entry.getValue();
/*  303 */           CtMethod baseMethod = (CtMethod)baseMethods.get(hash);
/*  304 */           if ((baseMethod != null) && (!addedMethods.contains(hash)))
/*      */           {
/*  306 */             String msg = "Mixin " + mixinClass.getName() + " of pointcut " + pointcut.getName() + " is trying to apply an already existing method" + method.getName() + " for class " + clazz.getName();
/*      */ 
/*  310 */             if (baseMethod.getDeclaringClass().equals(clazz))
/*      */             {
/*  312 */               throw new RuntimeException(msg);
/*      */             }
/*      */ 
/*  316 */             if (AspectManager.verbose) logger.warn(msg);
/*      */ 
/*      */           }
/*      */ 
/*  320 */           if (addedMethods.contains(hash))
/*      */             continue;
/*      */           try {
/*  323 */             createMixinInvokeMethod(clazz, mixinClass, initializer, method, hash.longValue());
/*      */           }
/*      */           catch (CannotCompileException e)
/*      */           {
/*  327 */             String generatedCode = "class " + clazz.getName() + "\n{\n   ...\n" + "   private " + type.getName() + " = " + initializer + ";\n" + "   ...\n}";
/*      */ 
/*  330 */             throw new RuntimeException("Mixin construction expression '" + initializer + "' may have sintax error:\n" + generatedCode, e);
/*      */           }
/*      */ 
/*  333 */           baseMethods.put(hash, method);
/*  334 */           addedMethods.add(hash);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addIntroductionPointcutInterface(CtClass clazz, Advisor advisor, String intf, HashMap baseMethods) throws Exception {
/*  341 */     CtClass iface = this.classPool.get(intf);
/*  342 */     if ((!clazz.subtypeOf(iface)) && (!clazz.subclassOf(iface)))
/*      */     {
/*  344 */       clazz.addInterface(iface);
/*      */     }
/*      */ 
/*  347 */     CtMethod mixinInvokeMethod = createInvokeMethod(clazz);
/*  348 */     HashMap intfMap = JavassistMethodHashing.getMethodMap(iface);
/*  349 */     Iterator entries = intfMap.entrySet().iterator();
/*  350 */     while (entries.hasNext())
/*      */     {
/*  352 */       Map.Entry entry = (Map.Entry)entries.next();
/*  353 */       Long hash = (Long)entry.getKey();
/*  354 */       if (!baseMethods.containsKey(hash)) {
/*  355 */         CtMethod method = (CtMethod)entry.getValue();
/*  356 */         addMixinMethod(advisor, method, clazz, mixinInvokeMethod, hash.longValue());
/*  357 */         baseMethods.put(hash, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void instrumentIntroductions(CtClass clazz, Advisor advisor) throws Exception
/*      */   {
/*  364 */     ArrayList pointcuts = advisor.getInterfaceIntroductions();
/*      */ 
/*  366 */     if (pointcuts.size() == 0) return;
/*  367 */     HashMap baseMethods = JavassistMethodHashing.getDeclaredMethodMap(clazz);
/*  368 */     Iterator it = pointcuts.iterator();
/*  369 */     if (it.hasNext()) setupBasics(clazz);
/*  370 */     while (it.hasNext())
/*      */     {
/*  373 */       InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
/*  374 */       ArrayList mixins = pointcut.getMixins();
/*  375 */       for (int i = 0; i < mixins.size(); i++)
/*      */       {
/*  377 */         InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(i);
/*  378 */         addMixin(clazz, pointcut, mixin, baseMethods);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  384 */     it = pointcuts.iterator();
/*  385 */     while (it.hasNext())
/*      */     {
/*  387 */       InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
/*  388 */       String[] interfaces = pointcut.getInterfaces();
/*  389 */       if (interfaces != null)
/*  390 */         for (int i = 0; i < interfaces.length; i++)
/*      */         {
/*  392 */           addIntroductionPointcutInterface(clazz, advisor, interfaces[i], baseMethods);
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean instrumentAnnotationIntroductions(CtClass clazz, ClassAdvisor advisor)
/*      */     throws Exception
/*      */   {
/*  400 */     boolean changed = false;
/*  401 */     Iterator it = advisor.getManager().getAnnotationIntroductions().iterator();
/*  402 */     while (it.hasNext())
/*      */     {
/*  404 */       AnnotationIntroduction introduction = (AnnotationIntroduction)it.next();
/*  405 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("**** " + introduction.getOriginalAnnotationExpr() + " invisible: " + introduction.isInvisible() + " expr: " + introduction.getOriginalExpression());
/*  406 */       if (introduction.matches(advisor, clazz))
/*      */       {
/*  408 */         if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug(introduction.getAnnotation() + " binds to " + clazz.getName());
/*  409 */         Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.classPool, clazz.getClassFile2().getConstPool(), introduction.getAnnotation());
/*  410 */         if (introduction.isInvisible())
/*      */         {
/*  412 */           AnnotationsAttribute invisible = (AnnotationsAttribute)clazz.getClassFile2().getAttribute("RuntimeInvisibleAnnotations");
/*  413 */           if (invisible == null)
/*      */           {
/*  415 */             invisible = new AnnotationsAttribute(clazz.getClassFile2().getConstPool(), "RuntimeInvisibleAnnotations");
/*  416 */             clazz.getClassFile2().addAttribute(invisible);
/*      */           }
/*  418 */           changed = true;
/*  419 */           invisible.addAnnotation(info);
/*      */         }
/*      */         else
/*      */         {
/*  423 */           AnnotationsAttribute visible = (AnnotationsAttribute)clazz.getClassFile2().getAttribute("RuntimeVisibleAnnotations");
/*  424 */           if (visible == null)
/*      */           {
/*  426 */             visible = new AnnotationsAttribute(clazz.getClassFile2().getConstPool(), "RuntimeVisibleAnnotations");
/*  427 */             clazz.getClassFile2().addAttribute(visible);
/*      */           }
/*  429 */           changed = true;
/*  430 */           visible.addAnnotation(info);
/*      */         }
/*      */       }
/*      */ 
/*  434 */       CtMethod[] methods = clazz.getDeclaredMethods();
/*  435 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  437 */         if (!introduction.matches(advisor, methods[i]))
/*      */           continue;
/*  439 */         Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.classPool, methods[i].getMethodInfo2().getConstPool(), introduction.getAnnotation());
/*  440 */         MethodInfo mi = methods[i].getMethodInfo2();
/*  441 */         if (introduction.isInvisible())
/*      */         {
/*  443 */           AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  444 */           if (invisible == null)
/*      */           {
/*  446 */             invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
/*  447 */             mi.addAttribute(invisible);
/*      */           }
/*  449 */           changed = true;
/*  450 */           invisible.addAnnotation(info);
/*      */         }
/*      */         else
/*      */         {
/*  454 */           AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  455 */           if (visible == null)
/*      */           {
/*  457 */             visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
/*  458 */             mi.addAttribute(visible);
/*      */           }
/*  460 */           changed = true;
/*  461 */           visible.addAnnotation(info);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  467 */       CtConstructor[] cons = clazz.getDeclaredConstructors();
/*  468 */       for (int i = 0; i < cons.length; i++)
/*      */       {
/*  470 */         if (!introduction.matches(advisor, cons[i]))
/*      */           continue;
/*  472 */         Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.classPool, cons[i].getMethodInfo2().getConstPool(), introduction.getAnnotation());
/*  473 */         MethodInfo mi = cons[i].getMethodInfo2();
/*  474 */         if (introduction.isInvisible())
/*      */         {
/*  476 */           AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  477 */           if (invisible == null)
/*      */           {
/*  479 */             invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
/*  480 */             mi.addAttribute(invisible);
/*      */           }
/*  482 */           changed = true;
/*  483 */           invisible.addAnnotation(info);
/*      */         }
/*      */         else
/*      */         {
/*  487 */           AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  488 */           if (visible == null)
/*      */           {
/*  490 */             visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
/*  491 */             mi.addAttribute(visible);
/*      */           }
/*  493 */           changed = true;
/*  494 */           visible.addAnnotation(info);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  499 */       CtField[] fields = clazz.getDeclaredFields();
/*  500 */       for (int i = 0; i < fields.length; i++)
/*      */       {
/*  502 */         if (!introduction.matches(advisor, fields[i]))
/*      */           continue;
/*  504 */         Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.classPool, fields[i].getFieldInfo2().getConstPool(), introduction.getAnnotation());
/*  505 */         FieldInfo mi = fields[i].getFieldInfo2();
/*  506 */         if (introduction.isInvisible())
/*      */         {
/*  508 */           AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  509 */           if (invisible == null)
/*      */           {
/*  511 */             invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
/*  512 */             mi.addAttribute(invisible);
/*      */           }
/*  514 */           changed = true;
/*  515 */           invisible.addAnnotation(info);
/*      */         }
/*      */         else
/*      */         {
/*  519 */           AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  520 */           if (visible == null)
/*      */           {
/*  522 */             visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
/*  523 */             mi.addAttribute(visible);
/*      */           }
/*  525 */           changed = true;
/*  526 */           visible.addAnnotation(info);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  531 */     return changed;
/*      */   }
/*      */ 
/*      */   private boolean instrumentAnnotationOverrides(CtClass clazz, ClassAdvisor advisor)
/*      */     throws Exception
/*      */   {
/*  537 */     boolean changed = false;
/*  538 */     Iterator it = advisor.getManager().getAnnotationOverrides().iterator();
/*  539 */     while (it.hasNext())
/*      */     {
/*  541 */       AnnotationIntroduction introduction = (AnnotationIntroduction)it.next();
/*  542 */       if (introduction.matches(advisor, clazz))
/*      */       {
/*  544 */         advisor.getAnnotations().addClassAnnotation(introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
/*      */       }
/*      */ 
/*  547 */       CtMethod[] methods = clazz.getDeclaredMethods();
/*  548 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  550 */         if (!introduction.matches(advisor, methods[i]))
/*      */           continue;
/*  552 */         advisor.getAnnotations().addAnnotation(methods[i], introduction.getAnnotation().getIdentifier());
/*      */       }
/*      */ 
/*  556 */       CtConstructor[] cons = clazz.getDeclaredConstructors();
/*  557 */       for (int i = 0; i < cons.length; i++)
/*      */       {
/*  559 */         if (!introduction.matches(advisor, cons[i]))
/*      */           continue;
/*  561 */         advisor.getAnnotations().addAnnotation(cons[i], introduction.getAnnotation().getIdentifier());
/*      */       }
/*      */ 
/*  565 */       CtField[] fields = clazz.getDeclaredFields();
/*  566 */       for (int i = 0; i < fields.length; i++)
/*      */       {
/*  568 */         if (!introduction.matches(advisor, fields[i]))
/*      */           continue;
/*  570 */         advisor.getAnnotations().addAnnotation(fields[i], introduction.getAnnotation().getIdentifier());
/*      */       }
/*      */     }
/*      */ 
/*  574 */     return changed;
/*      */   }
/*      */ 
/*      */   public boolean applyCallerPointcuts(CtClass clazz, ClassAdvisor advisor) throws CannotCompileException
/*      */   {
/*  579 */     return this.callerTransformer.applyCallerPointcuts(clazz, advisor);
/*      */   }
/*      */ 
/*      */   protected boolean convertReferences(CtClass clazz)
/*      */     throws Exception
/*      */   {
/*  588 */     boolean converted = false;
/*  589 */     String ref = null;
/*      */     try
/*      */     {
/*  592 */       pool = AOPClassPool.createAOPClassPool(clazz.getClassPool(), AOPClassPoolRepository.getInstance());
/*      */ 
/*  595 */       for (it = new ReferenceClassIterator(clazz.getRefClasses()); it.hasNext(); )
/*      */       {
/*  597 */         ref = it.next();
/*  598 */         if ((!this.manager.getInterceptionMarkers().convertReference(ref)) || (this.manager.isNonAdvisableClassName(ref)) || (ref.startsWith("java.")) || (ref.startsWith("javax.")) || (ref.startsWith("[")))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*  607 */         CtClass ctRef = null;
/*      */         try
/*      */         {
/*  610 */           ctRef = pool.get(ref);
/*      */         }
/*      */         catch (NotFoundException e)
/*      */         {
/*  614 */           if (AspectManager.suppressReferenceErrors)
/*      */           {
/*  616 */             System.err.println("[warn] Could not find class " + ref + " that " + clazz.getName() + " references.  It may not be in your classpath and you may not be getting field and constructor weaving for this class.");
/*  617 */             if (AspectManager.verbose) e.printStackTrace();
/*  618 */             continue;
/*      */           }
/*      */ 
/*  622 */           throw e;
/*      */         }
/*      */ 
/*  625 */         if (!isTransformable(ctRef))
/*      */           continue;
/*  627 */         it.addSuperClass(ctRef);
/*      */ 
/*  629 */         ClassAdvisor advisor = this.manager.getTempClassAdvisor(ctRef);
/*      */ 
/*  632 */         if ((!this.manager.getInterceptionMarkers().shouldSkipFieldAccess(ref)) && (!ref.equals(clazz.getName())))
/*      */         {
/*  634 */           List fields = getAdvisableFields(ctRef);
/*  635 */           if (this.fieldAccessTransformer.replaceFieldAccess(fields, ctRef, advisor))
/*      */           {
/*  637 */             this.manager.getInterceptionMarkers().addFieldInterceptionMarker(ref);
/*  638 */             converted = true;
/*      */           }
/*      */           else
/*      */           {
/*  642 */             this.manager.getInterceptionMarkers().skipFieldAccess(ref);
/*      */           }
/*      */         }
/*  645 */         if (!this.manager.getInterceptionMarkers().shouldSkipConstruction(ref))
/*      */         {
/*  647 */           if (this.constructorExecutionTransformer.replaceConstructorAccess(advisor, ctRef))
/*      */           {
/*  649 */             this.manager.getInterceptionMarkers().addConstructionInterceptionMarker(ref);
/*  650 */             converted = true;
/*      */           }
/*      */           else
/*      */           {
/*  654 */             this.manager.getInterceptionMarkers().skipConstruction(ref);
/*      */           }
/*      */         }
/*      */ 
/*  658 */         if (!converted)
/*      */         {
/*  660 */           this.manager.getInterceptionMarkers().skipReference(ref);
/*      */         }
/*  662 */         ref = null;
/*      */       }
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/*      */       AOPClassPool pool;
/*      */       ReferenceClassIterator it;
/*  667 */       if (ref != null)
/*      */       {
/*  669 */         throw new TransformationException("Failed to aspectize class " + clazz.getName() + ".  Could not find class it references " + ref + "  It may not be in your classpath and you may not be getting field and constructor weaving for this class.");
/*      */       }
/*  671 */       throw ex;
/*      */     }
/*  673 */     return converted;
/*      */   }
/*      */ 
/*      */   protected boolean shouldNotTransform(CtClass clazz) throws NotFoundException
/*      */   {
/*  678 */     return (clazz.isInterface()) || (clazz.isFrozen()) || (clazz.isArray()) || (clazz.getName().startsWith("org.jboss.aop")) || (isAdvised(clazz)) || (!isTransformable(clazz));
/*      */   }
/*      */ 
/*      */   public boolean transform(CtClass clazz, ClassAdvisor advisor)
/*      */   {
/*      */     try
/*      */     {
/*  694 */       if (shouldNotTransform(clazz)) return false;
/*  695 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("trying to transform " + clazz.getName());
/*      */ 
/*  697 */       DeclareChecker.checkDeclares(this.manager, clazz, advisor);
/*      */ 
/*  699 */       boolean converted = instrumentAnnotationIntroductions(clazz, advisor);
/*  700 */       converted = (instrumentAnnotationOverrides(clazz, advisor)) || (converted);
/*  701 */       boolean constructorAccessConverted = false;
/*  702 */       converted = (applyCallerPointcuts(clazz, advisor)) || (converted);
/*  703 */       this.methodExecutionTransformer.instrument(clazz, advisor);
/*  704 */       boolean constructionTransformation = this.constructionTransformer.insertConstructionInterception(clazz, advisor);
/*  705 */       constructorAccessConverted = this.constructorExecutionTransformer.transform(clazz, advisor);
/*  706 */       String classname = clazz.getName();
/*  707 */       if (constructorAccessConverted)
/*      */       {
/*  709 */         this.manager.getInterceptionMarkers().addConstructionInterceptionMarker(classname);
/*      */       }
/*      */       else
/*      */       {
/*  713 */         this.manager.getInterceptionMarkers().skipConstruction(classname);
/*      */       }
/*  715 */       converted = (converted) || (constructorAccessConverted);
/*      */ 
/*  717 */       instrumentIntroductions(clazz, advisor);
/*      */ 
/*  719 */       converted = (convertReferences(clazz)) || (converted);
/*      */ 
/*  721 */       boolean shouldReplaceArrayAccess = replaceArrayAccess(clazz, advisor);
/*  722 */       converted = (converted) || (shouldReplaceArrayAccess);
/*      */ 
/*  727 */       if ((converted) || (this.basicsSet))
/*      */       {
/*  729 */         clazz.instrument(this.converter);
/*      */       }
/*      */ 
/*  734 */       this.fieldAccessTransformer.buildFieldWrappers(clazz, advisor, shouldReplaceArrayAccess);
/*  735 */       if (constructorAccessConverted)
/*      */       {
/*  737 */         this.constructorExecutionTransformer.codeConverted();
/*      */       }
/*  741 */       else if (this.manager.getInterceptionMarkers().shouldSkipFieldAccess(classname))
/*      */       {
/*  743 */         this.manager.getInterceptionMarkers().skipReference(classname);
/*      */       }
/*      */ 
/*  749 */       this.dynamicTransformationObserver.transformationFinished(clazz, this.converter);
/*      */ 
/*  751 */       synchronized (processedClasses)
/*      */       {
/*  753 */         processedClasses.add(clazz);
/*      */       }
/*      */ 
/*  756 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("was " + clazz.getName() + " converted: " + ((this.basicsSet) || (converted)));
/*      */ 
/*  760 */       return (this.basicsSet) || (converted);
/*      */     }
/*      */     catch (Throwable e)
/*      */     {
/*  771 */       if (AspectManager.suppressTransformationErrors)
/*      */       {
/*  773 */         System.err.println("[warn] AOP Instrumentor failed to transform " + clazz.getName());
/*  774 */         e.printStackTrace();
/*  775 */         return false;
/*      */       }
/*      */ 
/*  779 */       if ((e instanceof TransformationException))
/*      */       {
/*  781 */         throw ((TransformationException)e);
/*      */       }
/*      */ 
/*  785 */       e.printStackTrace();
/*  786 */     }throw new RuntimeException("failed to transform: " + clazz.getName(), e);
/*      */   }
/*      */ 
/*      */   public List getConstructors(CtClass clazz)
/*      */   {
/*  796 */     List list = new ArrayList();
/*      */ 
/*  798 */     CtConstructor[] constructors = clazz.getDeclaredConstructors();
/*      */ 
/*  800 */     for (int i = 0; i < constructors.length; i++)
/*      */     {
/*  802 */       list.add(constructors[i]);
/*      */     }
/*  804 */     Collections.sort(list, CtConstructorComparator.INSTANCE);
/*      */ 
/*  806 */     return list;
/*      */   }
/*      */ 
/*      */   public static List getAdvisableFields(CtClass clazz)
/*      */     throws NotFoundException
/*      */   {
/*  814 */     List list = new ArrayList();
/*  815 */     CtField[] fields = clazz.getDeclaredFields();
/*  816 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  818 */       if (!Advisable.isAdvisable(fields[i]))
/*      */         continue;
/*  820 */       list.add(fields[i]);
/*      */     }
/*      */ 
/*  823 */     Collections.sort(list, CtFieldComparator.INSTANCE);
/*      */ 
/*  825 */     return list;
/*      */   }
/*      */ 
/*      */   private CtMethod createInvokeMethod(CtClass clazz)
/*      */     throws CannotCompileException
/*      */   {
/*  834 */     return CtNewMethod.make("public java.lang.Object invoke(java.lang.Object[] args, long i)       throws java.lang.Throwable {   return ((org.jboss.aop.ClassAdvisor)this._getAdvisor()).invokeMethod(this, i, args);}", clazz);
/*      */   }
/*      */ 
/*      */   public CtClass forName(String name)
/*      */     throws NotFoundException
/*      */   {
/*  846 */     return this.classPool.get(name);
/*      */   }
/*      */ 
/*      */   public CtClass forName(ClassPool pool, String name)
/*      */     throws NotFoundException
/*      */   {
/*  854 */     return pool.get(name);
/*      */   }
/*      */ 
/*      */   protected CtField addStaticField(CtClass clazz, String name, String typeName, CtField.Initializer initializer)
/*      */     throws CannotCompileException, NotFoundException
/*      */   {
/*  865 */     CtClass type = forName(typeName);
/*  866 */     CtField field = new CtField(type, name, clazz);
/*  867 */     field.setModifiers(10);
/*  868 */     clazz.addField(field, initializer);
/*      */ 
/*  870 */     return field;
/*      */   }
/*      */ 
/*      */   protected CtField addProtectedField(CtClass clazz, String name, String typeName, CtField.Initializer initializer)
/*      */     throws CannotCompileException, NotFoundException
/*      */   {
/*  880 */     CtClass type = forName(typeName);
/*  881 */     CtField field = new CtField(type, name, clazz);
/*  882 */     field.setModifiers(132);
/*  883 */     if (initializer != null)
/*      */     {
/*  885 */       clazz.addField(field, initializer);
/*      */     }
/*      */     else
/*      */     {
/*  889 */       clazz.addField(field);
/*      */     }
/*  891 */     return field;
/*      */   }
/*      */ 
/*      */   public void setupBasics(CtClass clazz) throws CannotCompileException, NotFoundException
/*      */   {
/*  896 */     if (this.basicsSet) return;
/*  897 */     this.basicsSet = true;
/*      */ 
/*  899 */     SerialVersionUID.setSerialVersionUID(clazz);
/*      */ 
/*  902 */     clazz.addInterface(forName(AOP_PACKAGE + ".Advised"));
/*      */ 
/*  904 */     doSetupBasics(clazz);
/*      */   }
/*      */ 
/*      */   public synchronized void interceptorChainsUpdated(Collection joinpointUpdates, HotSwapper hotSwapper)
/*      */   {
/*  915 */     this.converter = new CodeConverter();
/*      */ 
/*  917 */     Collection classes = new HashSet();
/*      */     try
/*      */     {
/*  920 */       for (Iterator iterator = joinpointUpdates.iterator(); iterator.hasNext(); )
/*      */       {
/*  922 */         JoinpointStatusUpdate update = (JoinpointStatusUpdate)iterator.next();
/*  923 */         CtClass clazz = update.clazz;
/*  924 */         JoinpointStatusUpdate.ClassJoinpoints wrapTargets = update.newlyAdvisedJoinpoints;
/*  925 */         JoinpointStatusUpdate.ClassJoinpoints unwrapTargets = update.newlyUnadvisedJoinpoints;
/*      */ 
/*  927 */         clazz.defrost();
/*  928 */         this.fieldAccessTransformer.wrap(clazz, wrapTargets.fieldReads, wrapTargets.fieldWrites);
/*  929 */         this.fieldAccessTransformer.unwrap(clazz, unwrapTargets.fieldReads, unwrapTargets.fieldWrites);
/*  930 */         this.constructorExecutionTransformer.wrap(clazz, wrapTargets.constructorExecutions);
/*  931 */         this.constructorExecutionTransformer.unwrap(clazz, unwrapTargets.constructorExecutions);
/*  932 */         this.methodExecutionTransformer.wrap(clazz, wrapTargets.methodExecutions);
/*  933 */         this.methodExecutionTransformer.unwrap(clazz, unwrapTargets.methodExecutions);
/*  934 */         if (!update.isEmpty())
/*      */         {
/*  936 */           clazz.instrument(this.converter);
/*  937 */           classes.add(clazz);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  942 */       Collection classPools = AspectManager.getRegisteredCLs().values();
/*  943 */       Collection conversionsRegistered = new HashSet();
/*      */       Iterator iterator2;
/*  944 */       synchronized (processedClasses)
/*      */       {
/*  946 */         for (iterator2 = processedClasses.iterator(); iterator2.hasNext(); )
/*      */         {
/*  948 */           CtClass clazz = (CtClass)iterator2.next();
/*  949 */           if ((this.manager.isNonAdvisableClassName(clazz.getName())) || (!isTransformable(clazz)) || 
/*  954 */             (classes.contains(clazz)))
/*      */           {
/*      */             continue;
/*      */           }
/*      */ 
/*  959 */           clazz.defrost();
/*  960 */           byte[] previousByteCode = clazz.toBytecode();
/*  961 */           clazz.defrost();
/*  962 */           clazz.instrument(this.converter);
/*  963 */           if (!Arrays.equals(clazz.toBytecode(), previousByteCode))
/*      */           {
/*  965 */             classes.add(clazz);
/*      */           }
/*  967 */           clazz.defrost();
/*      */         }
/*      */       }
/*      */ 
/*  971 */       this.fieldAccessTransformer.codeConverted();
/*  972 */       this.constructorExecutionTransformer.codeConverted();
/*      */ 
/*  975 */       for (Iterator iterator = classes.iterator(); iterator.hasNext(); )
/*      */       {
/*  977 */         CtClass clazz = (CtClass)iterator.next();
/*  978 */         AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
/*  979 */         clazz.defrost();
/*  980 */         hotSwapper.registerChange(classPool.getClassLoader().loadClass(clazz.getName()), clazz.toBytecode());
/*      */       }
/*      */ 
/*  984 */       hotSwapper.hotSwap();
/*      */     }
/*      */     catch (Exception e) {
/*  987 */       e.printStackTrace();
/*  988 */       if (AspectManager.suppressTransformationErrors)
/*      */       {
/*  990 */         System.err.println("[warn] AOP Instrumentor failed to updated wrapping status.");
/*  991 */         e.printStackTrace();
/*      */       }
/*      */       else
/*      */       {
/*  995 */         if ((e instanceof TransformationException))
/*      */         {
/*  997 */           throw ((TransformationException)e);
/*      */         }
/*      */ 
/* 1001 */         throw new RuntimeException("failed to update wrapping status", e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean replaceArrayAccess(CtClass clazz, Advisor advisor)
/*      */     throws Exception
/*      */   {
/* 1009 */     boolean shouldReplaceArrayAccess = false;
/* 1010 */     Map arrayReplacements = this.manager.getArrayReplacements();
/* 1011 */     for (Iterator it = arrayReplacements.values().iterator(); it.hasNext(); )
/*      */     {
/* 1013 */       ArrayReplacement arrayReplacement = (ArrayReplacement)it.next();
/* 1014 */       if (arrayReplacement.matches(advisor, clazz))
/*      */       {
/* 1016 */         shouldReplaceArrayAccess = true;
/* 1017 */         break;
/*      */       }
/*      */     }
/*      */ 
/* 1021 */     if (shouldReplaceArrayAccess)
/*      */     {
/* 1023 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("[debug] Replacing array access in " + clazz.getName());
/* 1024 */       this.converter.replaceArrayAccess(this.classPool.get(ArrayAdvisor.class.getName()), new CodeConverter.DefaultArrayAccessReplacementMethodNames());
/*      */     }
/* 1026 */     return shouldReplaceArrayAccess;
/*      */   }
/*      */ 
/*      */   public void convertProcessedClasses(HotSwapper hotSwapper, CtClass clazz, Collection fieldReads, Collection fieldWrites, boolean constructor)
/*      */   {
/* 1048 */     AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
/* 1049 */     CodeConverter codeConverter = new CodeConverter();
/* 1050 */     for (Iterator iterator = fieldReads.iterator(); iterator.hasNext(); )
/*      */     {
/* 1052 */       CtField field = (CtField)iterator.next();
/* 1053 */       codeConverter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
/*      */     }
/* 1055 */     for (Iterator iterator = fieldWrites.iterator(); iterator.hasNext(); )
/*      */     {
/* 1057 */       CtField field = (CtField)iterator.next();
/* 1058 */       codeConverter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
/*      */     }
/* 1060 */     if (constructor)
/*      */     {
/* 1062 */       codeConverter.replaceNew(clazz, clazz, ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()));
/*      */     }
/*      */     Iterator iterator;
/* 1065 */     synchronized (processedClasses)
/*      */     {
/* 1067 */       for (iterator = processedClasses.iterator(); iterator.hasNext(); )
/*      */       {
/* 1069 */         CtClass processedClass = (CtClass)iterator.next();
/* 1070 */         if ((processedClass == clazz) || 
/* 1072 */           (processedClass.getRefClasses() == null) || (!clazz.getRefClasses().contains(clazz.getName())))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*      */         try
/*      */         {
/* 1079 */           processedClass.defrost();
/* 1080 */           byte[] previousByteCode = processedClass.toBytecode();
/* 1081 */           processedClass.defrost();
/* 1082 */           processedClass.instrument(codeConverter);
/* 1083 */           byte[] updatedByteCode = processedClass.toBytecode();
/* 1084 */           if (!Arrays.equals(updatedByteCode, previousByteCode))
/*      */           {
/* 1086 */             hotSwapper.registerChange(classPool.getClassLoader().loadClass(processedClass.getName()), updatedByteCode);
/*      */           }
/* 1088 */           processedClass.defrost();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1092 */           e.printStackTrace();
/* 1093 */           if (AspectManager.suppressTransformationErrors)
/*      */           {
/* 1095 */             System.err.println("[warn] AOP Instrumentor failed to updated wrapping status.");
/* 1096 */             e.printStackTrace();
/*      */           } else {
/* 1098 */             if ((e instanceof TransformationException))
/*      */             {
/* 1100 */               throw ((TransformationException)e);
/*      */             }
/*      */ 
/* 1104 */             throw new RuntimeException("failed to update wrapping status", e);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1110 */     hotSwapper.hotSwap();
/*      */   }
/*      */ 
/*      */   protected abstract void doSetupBasics(CtClass paramCtClass)
/*      */     throws CannotCompileException, NotFoundException;
/*      */ 
/*      */   protected abstract CtMethod createMixinInvokeMethod(CtClass paramCtClass1, CtClass paramCtClass2, String paramString, CtMethod paramCtMethod, long paramLong)
/*      */     throws CannotCompileException, NotFoundException, Exception;
/*      */ 
/*      */   AspectManager getManager()
/*      */   {
/* 1177 */     return this.manager;
/*      */   }
/*      */ 
/*      */   private static class ReferenceClassIterator
/*      */   {
/*      */     int size;
/*      */     int current;
/*      */     ArrayList classes;
/*      */     HashSet handledClasses;
/*      */     String currentEntry;
/*      */ 
/*      */     public ReferenceClassIterator(Collection refClasses)
/*      */     {
/* 1131 */       this.size = refClasses.size();
/* 1132 */       this.classes = new ArrayList(refClasses.size());
/* 1133 */       this.classes.addAll(refClasses);
/* 1134 */       this.handledClasses = new HashSet(refClasses.size());
/*      */     }
/*      */ 
/*      */     boolean hasNext()
/*      */     {
/* 1139 */       while (this.current < this.size)
/*      */       {
/* 1141 */         String s = (String)this.classes.get(this.current++);
/* 1142 */         if (!this.handledClasses.contains(s))
/*      */         {
/* 1144 */           this.handledClasses.add(s);
/* 1145 */           this.currentEntry = s;
/* 1146 */           return true;
/*      */         }
/*      */       }
/* 1149 */       return false;
/*      */     }
/*      */ 
/*      */     String next()
/*      */     {
/* 1154 */       return this.currentEntry;
/*      */     }
/*      */ 
/*      */     void addSuperClass(CtClass clazz) throws NotFoundException
/*      */     {
/* 1159 */       if (clazz != null)
/*      */       {
/* 1161 */         CtClass superClass = clazz.getSuperclass();
/* 1162 */         if (superClass != null)
/*      */         {
/* 1164 */           String name = superClass.getName();
/* 1165 */           if (!this.handledClasses.contains(name))
/*      */           {
/* 1167 */             this.classes.add(name);
/* 1168 */             this.size += 1;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.Instrumentor
 * JD-Core Version:    0.6.0
 */