/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodByMethodInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.joinpoint.MethodCallByMethod;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class MethodByMethodJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_MByM_";
/*     */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_MByM_";
/*  50 */   private static final Class JOINPOINT_TYPE = MethodCallByMethod.class;
/*  51 */   private static final Class INVOCATION_TYPE = MethodCalledByMethodInvocation.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */   WeakReference<Class<?>> returnType;
/*     */   boolean hasCallingObject;
/*     */   boolean hasTargetObject;
/*     */ 
/*     */   public MethodByMethodJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  71 */     super(advisor, info, getParameters((MethodByMethodInfo)info), ((MethodByMethodInfo)info).getMethod().getParameterTypes().length, false);
/*     */ 
/*  74 */     if (!((MethodByMethodInfo)info).getMethod().getReturnType().equals(Void.TYPE))
/*     */     {
/*  76 */       this.returnType = new WeakReference(((MethodByMethodInfo)info).getMethod().getReturnType());
/*     */     }
/*  78 */     this.hasCallingObject = (!java.lang.reflect.Modifier.isStatic(((MethodByMethodInfo)info).getCallingMethod().getModifiers()));
/*  79 */     this.hasTargetObject = (!java.lang.reflect.Modifier.isStatic(((MethodByMethodInfo)info).getMethod().getModifiers()));
/*     */   }
/*     */ 
/*     */   private static JoinPointGenerator.JoinPointParameters getParameters(MethodByMethodInfo info)
/*     */   {
/*  84 */     if (javassist.Modifier.isStatic(info.getCallingMethod().getModifiers()))
/*     */     {
/*  86 */       if (javassist.Modifier.isStatic(info.getMethod().getModifiers()))
/*     */       {
/*  88 */         return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
/*     */       }
/*  90 */       return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
/*     */     }
/*  92 */     if (javassist.Modifier.isStatic(info.getMethod().getModifiers()))
/*     */     {
/*  94 */       return JoinPointGenerator.JoinPointParameters.CALLER_ARGS;
/*     */     }
/*  96 */     return JoinPointGenerator.JoinPointParameters.TARGET_CALLER_ARGS;
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/* 101 */     MethodByMethodInfo minfo = (MethodByMethodInfo)info;
/* 102 */     this.joinpointClassName = getGeneratedJoinPointClassName(callingMethodHash(minfo), calledClass(minfo), calledMethodHash(minfo));
/*     */ 
/* 107 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(callingMethodHash(minfo), calledClass(minfo), calledMethodHash(minfo));
/*     */   }
/*     */ 
/*     */   private long callingMethodHash(MethodByMethodInfo info)
/*     */   {
/* 115 */     return info.getCallingMethodHash();
/*     */   }
/*     */ 
/*     */   private String calledClass(MethodByMethodInfo info)
/*     */   {
/* 120 */     return info.getCalledClass().getName();
/*     */   }
/*     */ 
/*     */   private long calledMethodHash(MethodByMethodInfo info)
/*     */   {
/* 125 */     return info.getCalledMethodHash();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 130 */     return getReturnClassType() == null;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 135 */     if (this.returnType == null)
/*     */     {
/* 137 */       return null;
/*     */     }
/* 139 */     return (Class)this.returnType.get();
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 144 */     Method method = ((MethodCallByMethod)joinPoint).getMethod();
/* 145 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), hasTargetObject(), ((MethodCallByMethod)joinPoint).getCallingClass(), hasCallingObject());
/*     */   }
/*     */ 
/*     */   protected boolean isCaller()
/*     */   {
/* 163 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean hasCallingObject()
/*     */   {
/* 168 */     return this.hasCallingObject;
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 173 */     return this.hasTargetObject;
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, long callingHash, boolean hasCallingObject, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 186 */     BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingHash, hasCallingObject, classname, targetMethod, calledHash, ciname);
/* 187 */     return generator.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointClassName(long callingHash, String classname, long calledHash)
/*     */   {
/* 192 */     return "JoinPoint_MByM_" + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(long callingHash, String classname, long calledHash)
/*     */   {
/* 197 */     return "joinpoint_MByM_" + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  57 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  61 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass callingClass;
/*     */     long callingHash;
/*     */     boolean hasCallingObject;
/*     */     String classname;
/*     */     CtClass targetClass;
/*     */     CtMethod targetMethod;
/*     */     long calledHash;
/*     */     String ciname;
/*     */     boolean hasTargetObject;
/*     */     CtClass jp;
/*     */     CtClass[] params;
/*     */     CtClass methodInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, long callingHash, boolean hasCallingObject, String classname, CtMethod targetMethod, long calledHash, String ciname)
/*     */       throws NotFoundException
/*     */     {
/* 227 */       this.instrumentor = instrumentor;
/* 228 */       this.callingClass = callingClass;
/* 229 */       this.callingHash = callingHash;
/* 230 */       this.classname = classname;
/* 231 */       this.hasCallingObject = hasCallingObject;
/* 232 */       this.targetClass = instrumentor.forName(classname);
/* 233 */       this.targetMethod = targetMethod;
/* 234 */       this.calledHash = calledHash;
/* 235 */       this.ciname = ciname;
/* 236 */       this.params = targetMethod.getParameterTypes();
/* 237 */       this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_METHOD_INFO_CLASS_NAME);
/* 238 */       this.hasTargetObject = (!javassist.Modifier.isStatic(targetMethod.getModifiers()));
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 243 */       this.jp = setupClass();
/* 244 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
/*     */ 
/* 246 */       if (this.hasTargetObject)
/*     */       {
/* 248 */         addTypedTargetField();
/*     */       }
/* 250 */       if (this.hasCallingObject)
/*     */       {
/* 252 */         addTypedCallingField();
/*     */       }
/* 254 */       addInvokeJoinpointMethod();
/* 255 */       addMethodInfoField();
/* 256 */       addPublicConstructor();
/* 257 */       addProtectedConstructors();
/* 258 */       addDispatchMethods();
/*     */ 
/* 260 */       TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
/* 261 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 267 */       String className = MethodByMethodJoinPointGenerator.getGeneratedJoinPointClassName(this.callingHash, this.targetClass.getName(), this.calledHash);
/*     */ 
/* 270 */       this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true);
/* 271 */       int mod = this.jp.getModifiers();
/* 272 */       this.jp.setModifiers(mod | 0x1);
/*     */ 
/* 274 */       CtClass invocation = MethodByMethodJoinPointGenerator.INVOCATION_CT_TYPE;
/* 275 */       this.jp.setSuperclass(invocation);
/* 276 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 277 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addTypedTargetField() throws CannotCompileException
/*     */     {
/* 282 */       CtField targetField = new CtField(this.targetClass, "typedTargetObject", this.jp);
/* 283 */       this.jp.addField(targetField);
/* 284 */       targetField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addTypedCallingField() throws CannotCompileException
/*     */     {
/* 289 */       CtField callingField = new CtField(this.callingClass, "typedCallingObject", this.jp);
/* 290 */       this.jp.addField(callingField);
/* 291 */       callingField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 301 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.methodInfoClass }, new CtClass[0], "{super($1, null, null, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 307 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 316 */       int offset = 1;
/* 317 */       if (this.hasTargetObject) offset++;
/* 318 */       if (this.hasCallingObject) offset++;
/* 319 */       CtClass[] ctorParams1 = new CtClass[this.params.length + offset];
/* 320 */       CtClass[] ctorParams2 = new CtClass[offset];
/*     */ 
/* 322 */       int index = 0;
/*     */       CtClass tmp54_51 = this.jp; ctorParams2[(index++)] = tmp54_51; ctorParams1[index] = tmp54_51;
/* 324 */       if (this.hasTargetObject)
/*     */       {
/*     */         CtClass tmp77_74 = this.targetClass; ctorParams2[(index++)] = tmp77_74; ctorParams1[index] = tmp77_74;
/* 325 */       }if (this.hasCallingObject)
/*     */       {
/*     */         CtClass tmp100_97 = this.callingClass; ctorParams2[(index++)] = tmp100_97; ctorParams1[index] = tmp100_97;
/* 326 */       }System.arraycopy(this.params, 0, ctorParams1, offset, this.params.length);
/*     */ 
/* 328 */       StringBuffer body = new StringBuffer();
/* 329 */       body.append("{");
/* 330 */       body.append("   this($1.info);");
/* 331 */       if (this.hasTargetObject)
/*     */       {
/* 333 */         body.append("   super.").append("targetObject").append("=$2;");
/* 334 */         body.append("   this.").append("typedTargetObject").append("=$2;");
/*     */       }
/* 336 */       if (this.hasCallingObject)
/*     */       {
/* 338 */         int arg = this.hasTargetObject ? 3 : 2;
/* 339 */         body.append("   super.").append("callingObject");
/* 340 */         body.append("=$").append(arg).append(';');
/* 341 */         body.append("   this.").append("typedCallingObject");
/* 342 */         body.append("=$").append(arg).append(';');
/*     */       }
/*     */ 
/* 345 */       StringBuffer setArguments = new StringBuffer();
/* 346 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 348 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/* 350 */       setArguments.append("}");
/*     */ 
/* 352 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 357 */       protectedConstructor.setModifiers(4);
/* 358 */       this.jp.addConstructor(protectedConstructor);
/* 359 */       if (this.params.length > 0)
/*     */       {
/* 361 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 366 */         protectedConstructor.setModifiers(4);
/* 367 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtClass[] getInvokeJoinpointParameters()
/*     */     {
/* 373 */       if ((!this.hasCallingObject) && (!this.hasTargetObject))
/*     */       {
/* 375 */         return this.params;
/*     */       }
/*     */ 
/* 378 */       int offset = 0;
/* 379 */       if (this.hasTargetObject) offset++;
/* 380 */       if (this.hasCallingObject) offset++;
/* 381 */       CtClass[] invokeParams = new CtClass[this.params.length + offset];
/*     */ 
/* 383 */       int index = 0;
/* 384 */       if (this.hasTargetObject) invokeParams[(index++)] = this.targetClass;
/* 385 */       if (this.hasCallingObject) invokeParams[(index++)] = this.callingClass;
/* 386 */       System.arraycopy(this.params, 0, invokeParams, offset, this.params.length);
/*     */ 
/* 388 */       return invokeParams;
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 396 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.targetMethod.getReturnType(), "invokeJoinpoint", getInvokeJoinpointParameters(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 404 */       invokeJoinpointMethod.setModifiers(4);
/* 405 */       this.jp.addMethod(invokeJoinpointMethod);
/* 406 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addMethodInfoField() throws CannotCompileException
/*     */     {
/* 411 */       CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
/* 412 */       infoField.setModifiers(4);
/* 413 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 418 */       OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
/*     */ 
/* 420 */       if ((this.hasCallingObject) || (this.hasTargetObject) || (this.params.length > 0))
/*     */       {
/* 422 */         addInvokeJoinPointDispatchMethod();
/*     */       }
/* 424 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinPointDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 430 */       boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
/* 431 */       CtClass[] invokeParams = getInvokeJoinpointParameters();
/*     */ 
/* 433 */       int offset = invokeParams.length - this.params.length;
/* 434 */       StringBuffer parameters = new StringBuffer();
/* 435 */       for (int i = 0; i < this.params.length; i++)
/*     */       {
/* 437 */         if (i > 0) parameters.append(", ");
/* 438 */         parameters.append("$" + (i + offset + 1));
/*     */       }
/*     */ 
/* 441 */       StringBuffer body = new StringBuffer("{");
/*     */ 
/* 443 */       if (this.hasTargetObject)
/*     */       {
/* 445 */         body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
/*     */       }
/*     */       else
/*     */       {
/* 449 */         body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
/*     */       }
/*     */ 
/* 452 */       body.append("}");
/*     */       try
/*     */       {
/* 455 */         CtMethod dispatch = CtNewMethod.make(isVoid ? CtClass.voidType : this.targetMethod.getReturnType(), "dispatch", invokeParams, this.targetMethod.getExceptionTypes(), body.toString(), this.jp);
/*     */ 
/* 462 */         dispatch.setModifiers(4);
/* 463 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 467 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", invokeParams), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 473 */       CtMethod template = MethodByMethodJoinPointGenerator.INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 475 */       boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
/* 476 */       String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
/*     */ 
/* 478 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 485 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.MethodByMethodJoinPointGenerator
 * JD-Core Version:    0.6.0
 */