/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.FieldAccess;
/*     */ 
/*     */ public class NonOptimizedFieldAccessTransformer extends FieldAccessTransformer
/*     */ {
/*     */   public NonOptimizedFieldAccessTransformer(Instrumentor instrumentor)
/*     */   {
/*  44 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected void doBuildFieldWrappers(CtClass clazz, CtField field, int fieldIndex, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  50 */     this.instrumentor.setupBasics(clazz);
/*  51 */     boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
/*  52 */     boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
/*  53 */     int mod = getStaticModifiers(field);
/*     */ 
/*  60 */     buildWrapperPlaceHolders(clazz, field, isPrepared(classificationGet), isPrepared(classificationSet), mod);
/*     */     try {
/*  62 */       if (isPrepared(classificationGet))
/*     */       {
/*  64 */         addFieldReadInfoFieldWithAccessors(10, clazz, field);
/*  65 */         OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, true);
/*     */ 
/*  67 */         wrapper.prepareForWrapping(field, 0);
/*     */       }
/*     */ 
/*  70 */       if (isPrepared(classificationSet))
/*     */       {
/*  72 */         addFieldWriteInfoField(10, clazz, field);
/*  73 */         OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, false);
/*     */ 
/*  75 */         wrapper.prepareForWrapping(field, 1);
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/*  79 */       throw new CannotCompileException(e);
/*     */     }
/*     */ 
/*  83 */     if (wrappedGet)
/*     */     {
/*  85 */       wrapper.wrap(field, 0);
/*  86 */       if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/*  88 */         this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
/*     */       }
/*     */     }
/*  91 */     if (wrappedSet)
/*     */     {
/*  93 */       wrapper.wrap(field, 1);
/*  94 */       if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED))
/*     */       {
/*  96 */         this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 101 */     replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
/* 102 */     buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, fieldIndex);
/*     */   }
/*     */ 
/*     */   private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 109 */     if (doGet)
/*     */     {
/* 111 */       String code = getReadWrapperBody(clazz, field, index);
/* 112 */       CtMethod method = clazz.getDeclaredMethod(fieldRead(field.getName()));
/* 113 */       method.setBody(code);
/*     */     }
/* 115 */     if (doSet)
/*     */     {
/* 117 */       String code = getWriteWrapperBody(clazz, field, shouldReplaceArrayAccess, index);
/* 118 */       CtMethod method = clazz.getDeclaredMethod(fieldWrite(field.getName()));
/* 119 */       method.setBody(code);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int index) throws NotFoundException, CannotCompileException
/*     */   {
/* 125 */     if (get)
/*     */     {
/* 127 */       return getReadWrapperBody(clazz, field, index);
/*     */     }
/*     */ 
/* 130 */     return getWriteWrapperBody(clazz, field, false, index);
/*     */   }
/*     */ 
/*     */   private String getReadWrapperBody(CtClass clazz, CtField field, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 136 */     String access = "";
/* 137 */     String instanceCheck = "";
/* 138 */     String name = field.getName();
/* 139 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/* 140 */     if (!isStatic)
/*     */     {
/* 142 */       access = "((" + clazz.getName() + ")$1).";
/* 143 */       instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
/*     */     }
/*     */ 
/* 148 */     return "{     if (aop$classAdvisor$aop.hasAspects() " + instanceCheck + " ) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeRead($1, (int)" + index + "); " + "    } " + "    return " + access + name + "; " + "}";
/*     */   }
/*     */ 
/*     */   private String getWriteWrapperBody(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 162 */     String name = field.getName();
/* 163 */     boolean isStatic = Modifier.isStatic(field.getModifiers());
/* 164 */     String access = "";
/* 165 */     String instanceCheck = "";
/*     */     String fieldString;
/*     */     String targetString;
/*     */     String fieldString;
/* 168 */     if (!isStatic)
/*     */     {
/* 170 */       access = "((" + clazz.getName() + ")$1).";
/* 171 */       instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
/* 172 */       String targetString = "((" + clazz.getName() + ")$1)";
/* 173 */       fieldString = targetString + "." + field.getName();
/*     */     }
/*     */     else
/*     */     {
/* 177 */       targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
/* 178 */       fieldString = clazz.getName() + "." + field.getName();
/*     */     }
/*     */ 
/* 181 */     return "{     " + getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "    if (" + "aop$classAdvisor$aop" + ".hasAspects() " + instanceCheck + " ) " + "    { " + "       " + "aop$classAdvisor$aop" + ".invokeWrite($1, (int)" + index + ", ($w)$2); " + "    } " + "    else " + "    { " + "       " + access + name + " = $2; " + "    } " + "}";
/*     */   }
/*     */ 
/*     */   protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     throws CannotCompileException
/*     */   {
/* 198 */     NonOptimizedFieldAccessExprEditor expr = new NonOptimizedFieldAccessExprEditor(clazz, field, doGet, doSet, index);
/* 199 */     clazz.instrument(expr);
/*     */   }
/*     */ 
/*     */   protected class NonOptimizedFieldAccessExprEditor extends FieldAccessTransformer.FieldAccessExprEditor
/*     */   {
/*     */     public NonOptimizedFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     {
/* 207 */       super(clazz, field, doGet, doSet, index);
/*     */     }
/*     */ 
/*     */     protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 212 */       if (fieldAccess.isStatic())
/*     */       {
/* 214 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
/*     */ 
/* 219 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 223 */         String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
/*     */ 
/* 228 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 234 */       String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
/* 235 */       if (fieldAccess.isStatic())
/*     */       {
/* 237 */         String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
/*     */ 
/* 242 */         fieldAccess.replace(code);
/*     */       }
/*     */       else
/*     */       {
/* 247 */         String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
/*     */ 
/* 252 */         fieldAccess.replace(code);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.NonOptimizedFieldAccessTransformer
 * JD-Core Version:    0.6.0
 */