/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ 
/*     */ public class OptimizedCallerTransformer extends CallerTransformer
/*     */ {
/*     */   public OptimizedCallerTransformer(Instrumentor instrumentor, AspectManager manager)
/*     */   {
/*  42 */     super(instrumentor, manager, true, new ClassicCallerInfoAdder(instrumentor));
/*     */   }
/*     */ 
/*     */   protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz)
/*     */   {
/*  47 */     return new OptimizedCallerExprEditor(advisor, clazz);
/*     */   }
/*     */ 
/*     */   class OptimizedCallerExprEditor extends CallerTransformer.CallerExprEditor
/*     */   {
/*     */     public OptimizedCallerExprEditor(ClassAdvisor advisor, CtClass callingClass)
/*     */     {
/*  55 */       super(advisor, callingClass);
/*     */     }
/*     */ 
/*     */     protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException
/*     */     {
/*  60 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/*  62 */         String createName = getOptimizedMethodCalledByConstructorClassName(cd.callingIndex, this.callingClass.getName(), cd.calledHash);
/*  63 */         String invocationClassName = OptimizedCallerInvocations.createOptimizedMethodCalledByConInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledMethod, cd.callingIndex, cd.calledHash);
/*     */ 
/*  65 */         this.callerInfos.put(cd.callerInfoField, invocationClassName);
/*  66 */         OptimizedCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException
/*     */     {
/*  72 */       if (this.callerInfos.get(md.callerInfoField) == null)
/*     */       {
/*  74 */         String createName = getOptimizedMethodCalledByMethodClassName(md.callingHash, this.callingClass.getName(), md.calledHash);
/*  75 */         String invocationClassName = OptimizedCallerInvocations.createOptimizedMethodCalledByMethodInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, md.calledMethod, md.callingHash, md.calledHash);
/*     */ 
/*  77 */         this.callerInfos.put(md.callerInfoField, invocationClassName);
/*  78 */         OptimizedCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(this.callingClass, md.callerInfoField, md.callingHash, md.classname, md.calledHash);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException
/*     */     {
/*  84 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/*  88 */         if (!cd.isTgtConAdvised)
/*     */         {
/*  90 */           String createName = getOptimizedConCalledByMethodInvocationClassName(cd.callingHash, this.callingClass.getName(), cd.calledHash);
/*  91 */           String invocationClassName = OptimizedCallerInvocations.createOptimizedConCalledByMethodInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledConstructor, cd.callingHash, cd.calledHash);
/*  92 */           this.callerInfos.put(cd.callerInfoField, invocationClassName);
/*     */         }
/*     */         else
/*     */         {
/*  96 */           this.callerInfos.put(cd.callerInfoField, "whatever");
/*     */         }
/*     */ 
/*  99 */         OptimizedCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(this.callingClass, cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupConstructor(CallerTransformer.ConByConDetail cd) throws NotFoundException, CannotCompileException
/*     */     {
/* 105 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/* 109 */         if (!cd.isTgtConAdvised)
/*     */         {
/* 111 */           String createName = getOptimizedConCalledByConInvocationClassName(cd.callingIndex, this.callingClass.getName(), cd.calledHash);
/* 112 */           String invocationClassName = OptimizedCallerInvocations.createOptimizedConCalledByConInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledConstructor, cd.callingIndex, cd.calledHash);
/* 113 */           this.callerInfos.put(cd.callerInfoField, invocationClassName);
/*     */         }
/*     */         else
/*     */         {
/* 117 */           this.callerInfos.put(cd.callerInfoField, "whatever");
/*     */         }
/* 119 */         OptimizedCallerTransformer.this.callerInfoAdder.addConByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceMethodCallInCon(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 125 */       String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
/* 126 */       String typedTargetObject = Modifier.isStatic(cd.calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
/*     */ 
/* 128 */       String replaced = CallerTransformer.methodByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (info, this, $0, $args, info.getInterceptors());" + typedTargetObject + OptimizedBehaviourInvocations.setArguments(cd.calledMethod.getParameterTypes().length) + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
/*     */ 
/* 141 */       cd.call.replace(replaced);
/*     */     }
/*     */ 
/*     */     protected void replaceMethodCallInMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException
/*     */     {
/* 146 */       String callingObject = ", null";
/* 147 */       if (!Modifier.isStatic(md.where.getModifiers()))
/*     */       {
/* 149 */         callingObject = ", this";
/*     */       }
/*     */ 
/* 152 */       String invocationClassName = (String)this.callerInfos.get(md.callerInfoField);
/* 153 */       String typedTargetObject = Modifier.isStatic(md.calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
/*     */ 
/* 155 */       String replaced = CallerTransformer.methodByMethodInfoFromWeakReference("info", md.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (info" + callingObject + ", $0, $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(md.calledMethod.getParameterTypes().length) + typedTargetObject + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
/*     */ 
/* 168 */       md.call.replace(replaced);
/*     */     }
/*     */ 
/*     */     protected void replaceConCallInMethod(CallerTransformer.ConByMethodDetail cd)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 175 */       if (cd.isTgtConAdvised)
/*     */       {
/* 177 */         super.replaceConCallInMethod(cd);
/* 178 */         return;
/*     */       }
/* 180 */       String callingObject = "null";
/* 181 */       if (!Modifier.isStatic(cd.where.getModifiers()))
/*     */       {
/* 183 */         callingObject = "this";
/*     */       }
/*     */ 
/* 186 */       String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
/* 187 */       String replaced = CallerTransformer.conByMethodInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "java.lang.Object callingObject = " + callingObject + "; " + invocationClassName + " invocation = new " + invocationClassName + "    (info," + callingObject + ", $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(cd.calledConstructor.getParameterTypes().length) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
/*     */ 
/* 199 */       cd.call.replace(replaced);
/*     */     }
/*     */ 
/*     */     protected void replaceConCallInCon(CallerTransformer.ConByConDetail cd)
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 206 */       if (cd.isTgtConAdvised)
/*     */       {
/* 208 */         super.replaceConCallInCon(cd);
/* 209 */         return;
/*     */       }
/* 211 */       String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
/*     */ 
/* 213 */       String replaced = CallerTransformer.conByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "(info, this, $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(cd.calledConstructor.getParameterTypes().length) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
/*     */ 
/* 224 */       cd.call.replace(replaced);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedCallerTransformer
 * JD-Core Version:    0.6.0
 */