/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import javassist.CtClass;
/*    */ import javassist.CtConstructor;
/*    */ import javassist.Modifier;
/*    */ 
/*    */ public class OptimizedConstructionTransformer extends ConstructionTransformer
/*    */ {
/*    */   public OptimizedConstructionTransformer(Instrumentor instrumentor)
/*    */   {
/* 40 */     super(instrumentor);
/*    */   }
/*    */ 
/*    */   protected void insertInterception(CtConstructor constructor, int index) throws Exception
/*    */   {
/* 45 */     CtClass type = constructor.getDeclaringClass();
/*    */ 
/* 47 */     OptimizedConstructionInvocations.createOptimizedInvocationClass(this.instrumentor, type, constructor, index);
/* 48 */     createWrapper(type, constructor, constructor.getDeclaringClass(), index);
/*    */   }
/*    */ 
/*    */   private void createWrapper(CtClass type, CtConstructor constructor, CtClass clazz, int index) throws Exception
/*    */   {
/* 53 */     String invocationClass = OptimizedConstructionInvocations.getOptimizedInvocationClassName(type, index);
/* 54 */     if (!Modifier.isPublic(constructor.getModifiers())) {
/* 55 */       invocationClass = invocationClass.substring(invocationClass.lastIndexOf('.') + 1);
/* 56 */       invocationClass = clazz.getName() + "$" + invocationClass;
/*    */     }
/*    */ 
/* 59 */     String infoName = getConstructionInfoFieldName(clazz.getSimpleName(), index);
/*    */ 
/* 61 */     String code = "    " + constructionInfoFromWeakReference("info", infoName) + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors, " + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]); " + OptimizedBehaviourInvocations.setArguments(constructor.getParameterTypes().length) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.setTargetObject(this); " + "       invocation.invokeNext(); " + "    } ";
/*    */ 
/* 74 */     constructor.insertAfter(code, false);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedConstructionTransformer
 * JD-Core Version:    0.6.0
 */