/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.CtClass;
/*    */ import javassist.CtConstructor;
/*    */ import javassist.Modifier;
/*    */ import javassist.NotFoundException;
/*    */ 
/*    */ public class OptimizedConstructorExecutionTransformer extends ConstructorExecutionTransformer
/*    */ {
/*    */   public OptimizedConstructorExecutionTransformer(Instrumentor instrumentor)
/*    */   {
/* 41 */     super(instrumentor);
/*    */   }
/*    */ 
/*    */   protected void createWrapper(ConstructorExecutionTransformer.ConstructorTransformation trans) throws NotFoundException, CannotCompileException
/*    */   {
/* 46 */     String invocationClass = OptimizedConstructorInvocations.getOptimizedInvocationClassName(trans.getClazz(), trans.getIndex());
/* 47 */     if (!Modifier.isPublic(trans.getConstructor().getModifiers())) {
/* 48 */       invocationClass = invocationClass.substring(invocationClass.lastIndexOf('.') + 1);
/* 49 */       invocationClass = trans.getClazz().getName() + "$" + invocationClass;
/*    */     }
/*    */ 
/* 52 */     String infoName = getConstructorInfoFieldName(trans.getSimpleName(), trans.getIndex());
/* 53 */     String code = "{     " + constructorInfoFromWeakReference("info", infoName) + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors); " + "       invocation.setConstructor(info.getConstructor()); " + OptimizedBehaviourInvocations.setArguments(trans.getConstructor().getParameterTypes().length) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    return new " + trans.getClazz().getName() + "($$); " + "}";
/*    */ 
/* 70 */     this.codifier.addPendingCode(trans.getWrapperMethod(), code);
/*    */   }
/*    */ 
/*    */   protected void generateConstructorInfoField(CtClass clazz, CtConstructor constructor, int index) throws CannotCompileException, NotFoundException
/*    */   {
/* 75 */     super.generateConstructorInfoField(clazz, constructor, index);
/* 76 */     OptimizedConstructorInvocations.createOptimizedInvocationClass(getInstrumentor(), constructor.getDeclaringClass(), constructor, index);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.OptimizedConstructorExecutionTransformer
 * JD-Core Version:    0.6.0
 */