/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ConstructorCalledByMethodInvocationWrapper extends ConstructorCalledByMethodInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 3704470177577877004L;
/*     */   ConstructorCalledByMethodInvocation wrapped;
/*     */ 
/*     */   public ConstructorCalledByMethodInvocationWrapper(ConstructorCalledByMethodInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  47 */     super(wrapped.getCallingObject(), interceptors);
/*  48 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  53 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext() throws Throwable
/*     */   {
/*  58 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  62 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*  70 */     return this.wrapped.invokeNext();
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  75 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Class getCallingClass()
/*     */   {
/*  80 */     return this.wrapped.getCallingClass();
/*     */   }
/*     */ 
/*     */   public Method getCallingMethod()
/*     */   {
/*  85 */     return this.wrapped.getCallingMethod();
/*     */   }
/*     */ 
/*     */   public Constructor getCalledConstructor()
/*     */   {
/*  90 */     return this.wrapped.getCalledConstructor();
/*     */   }
/*     */ 
/*     */   public boolean isWrapped()
/*     */   {
/*  95 */     return this.wrapped.isWrapped();
/*     */   }
/*     */ 
/*     */   public Method getWrappingMethod()
/*     */   {
/* 100 */     return this.wrapped.getWrappingMethod();
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 105 */     ConstructorCalledByMethodInvocationWrapper invocation = new ConstructorCalledByMethodInvocationWrapper((ConstructorCalledByMethodInvocation)this.wrapped.copy(), this.interceptors);
/* 106 */     invocation.currentInterceptor = this.currentInterceptor;
/* 107 */     return invocation;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 112 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 117 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 122 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 127 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 132 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 137 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 142 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 147 */     return this.wrapped.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 152 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 157 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/* 162 */     this.wrapped.setArguments(arguments);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocationWrapper
 * JD-Core Version:    0.6.0
 */