/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.metadata.ThreadMetaData;
/*     */ 
/*     */ public abstract class InvocationBase
/*     */   implements Serializable, Invocation
/*     */ {
/*     */   static final long serialVersionUID = -4880246394729260729L;
/*  45 */   protected SimpleMetaData metadata = null;
/*     */ 
/*  48 */   protected transient int currentInterceptor = 0;
/*  49 */   protected transient Interceptor[] interceptors = null;
/*  50 */   protected transient Advisor advisor = null;
/*  51 */   protected transient Map responseContextInfo = null;
/*     */ 
/*  53 */   protected transient Object targetObject = null;
/*     */   protected transient MetaDataResolver instanceResolver;
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/*  60 */     return this.responseContextInfo;
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/*  65 */     this.responseContextInfo = responseContextInfo;
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/*  70 */     if (this.responseContextInfo == null) this.responseContextInfo = new HashMap(1);
/*  71 */     this.responseContextInfo.put(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/*  76 */     if (this.responseContextInfo == null) return null;
/*  77 */     return this.responseContextInfo.get(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/*  85 */     if (this.metadata == null) this.metadata = new SimpleMetaData();
/*  86 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/*  94 */     this.metadata = data;
/*     */   }
/*     */ 
/*     */   public Object resolveClassMetaData(Object key, Object attr)
/*     */   {
/*  99 */     return getAdvisor().getClassMetaData().getMetaData(key, attr);
/*     */   }
/*     */ 
/*     */   public int getCurrentInterceptor()
/*     */   {
/* 104 */     return this.currentInterceptor;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 116 */       Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */       return localObject1; } finally { this.currentInterceptor -= 1; } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/* 131 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invokeNext(Interceptor[] newInterceptors)
/*     */     throws Throwable
/*     */   {
/* 144 */     Interceptor[] oldInterceptors = this.interceptors;
/* 145 */     int oldCurrentInterceptor = this.currentInterceptor;
/*     */ 
/* 148 */     this.interceptors = newInterceptors;
/* 149 */     this.currentInterceptor = 0;
/*     */     try
/*     */     {
/* 154 */       Object localObject1 = invokeNext();
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 159 */       this.interceptors = oldInterceptors;
/* 160 */       this.currentInterceptor = oldCurrentInterceptor; } throw localObject2;
/*     */   }
/*     */ 
/*     */   public InvocationBase(Interceptor[] interceptors)
/*     */   {
/* 166 */     this(interceptors, null);
/*     */   }
/*     */ 
/*     */   public InvocationBase(Interceptor[] interceptors, SimpleMetaData meta)
/*     */   {
/* 175 */     this.interceptors = interceptors;
/* 176 */     this.metadata = meta;
/*     */   }
/*     */ 
/*     */   public InvocationBase(Invocation invocation)
/*     */   {
/* 184 */     this.interceptors = invocation.getInterceptors();
/* 185 */     setTargetObject(invocation.getTargetObject());
/*     */   }
/*     */ 
/*     */   public InvocationBase()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors()
/*     */   {
/* 199 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/* 205 */     if (this.advisor != null) return this.advisor.resolveAnnotation(annotation);
/* 206 */     return null;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 212 */     return null;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class[] annotations)
/*     */   {
/* 218 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 232 */     Object val = null;
/* 233 */     if (this.metadata != null)
/*     */     {
/* 235 */       val = this.metadata.resolve(this, group, attr);
/* 236 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 239 */     val = ThreadMetaData.instance().resolve(this, group, attr);
/* 240 */     if (val != null) return val;
/*     */ 
/* 242 */     MetaDataResolver resolver = getInstanceResolver();
/* 243 */     if (resolver != null)
/*     */     {
/* 245 */       val = getInstanceResolver().resolve(this, group, attr);
/* 246 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 249 */     return null;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/* 254 */     if (this.instanceResolver != null) return this.instanceResolver;
/* 255 */     if (getTargetObject() != null)
/*     */     {
/* 257 */       if ((getTargetObject() instanceof InstanceAdvised))
/*     */       {
/* 259 */         InstanceAdvisor ia = ((InstanceAdvised)getTargetObject())._getInstanceAdvisor();
/* 260 */         if (ia != null)
/*     */         {
/* 263 */           this.instanceResolver = ia.getMetaData();
/* 264 */           return this.instanceResolver;
/*     */         }
/*     */       }
/*     */     }
/* 268 */     return null;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 273 */     return this.advisor;
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 278 */     return this.targetObject;
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 283 */     this.targetObject = targetObject;
/*     */   }
/*     */ 
/*     */   public void setAdvisor(Advisor advisor)
/*     */   {
/* 288 */     this.advisor = advisor;
/*     */   }
/*     */ 
/*     */   public void setInstanceResolver(MetaDataResolver instanceResolver)
/*     */   {
/* 293 */     this.instanceResolver = instanceResolver;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.InvocationBase
 * JD-Core Version:    0.6.0
 */