/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.MethodByConInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class MethodCalledByConstructorInvocation extends CallerInvocation
/*     */ {
/*     */   private static final long serialVersionUID = -1903092605231217830L;
/*     */   protected Constructor calling;
/*     */   protected Method method;
/*     */ 
/*     */   public MethodCalledByConstructorInvocation(MethodByConInfo info, Object callingObject, Object target, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  51 */     this(info.getAdvisor(), info.getCallingConstructor(), info.getMethod(), callingObject, target, args, interceptors);
/*     */   }
/*     */ 
/*     */   public MethodCalledByConstructorInvocation(MethodByConInfo info, Object callingObject, Object target, Interceptor[] interceptors)
/*     */   {
/*  56 */     this(info.getAdvisor(), info.getCallingConstructor(), info.getMethod(), callingObject, target, null, interceptors);
/*     */   }
/*     */ 
/*     */   public MethodCalledByConstructorInvocation(Advisor advisor, Constructor calling, Method method, Object callingObject, Object target, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  61 */     super(advisor, callingObject, interceptors);
/*  62 */     this.calling = calling;
/*  63 */     this.method = method;
/*  64 */     setTargetObject(target);
/*  65 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public MethodCalledByConstructorInvocation(Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  70 */     super(callingObject, interceptors);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  80 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  84 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  93 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 104 */       return this.method.invoke(getTargetObject(), this.arguments);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 108 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 123 */     Object val = super.getMetaData(group, attr);
/* 124 */     if (val != null) return val;
/*     */ 
/* 127 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 141 */     MethodCalledByConstructorInvocationWrapper wrapper = new MethodCalledByConstructorInvocationWrapper(this, newchain);
/* 142 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 152 */     MethodCalledByConstructorInvocation wrapper = new MethodCalledByConstructorInvocation(this.advisor, this.calling, this.method, this.callingObject, this.targetObject, this.arguments, this.interceptors);
/*     */ 
/* 154 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 155 */     wrapper.metadata = this.metadata;
/* 156 */     wrapper.instanceResolver = this.instanceResolver;
/* 157 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Constructor getCalling()
/*     */   {
/* 167 */     return this.calling;
/*     */   }
/*     */ 
/*     */   public Method getCalledMethod()
/*     */   {
/* 176 */     return this.method;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation
 * JD-Core Version:    0.6.0
 */