/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class MethodCalledByConstructorInvocationWrapper extends MethodCalledByConstructorInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 4578273471486761147L;
/*     */   MethodCalledByConstructorInvocation wrapped;
/*     */ 
/*     */   public MethodCalledByConstructorInvocationWrapper(MethodCalledByConstructorInvocation wrapped, Interceptor[] interceptors)
/*     */   {
/*  47 */     super(wrapped.getCallingObject(), interceptors);
/*  48 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/*  53 */     return this.wrapped.getMetaData(group, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  58 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  62 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  72 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public MetaDataResolver getInstanceResolver()
/*     */   {
/*  82 */     return this.wrapped.getInstanceResolver();
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/*  87 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/*  92 */     this.wrapped.setArguments(arguments);
/*     */   }
/*     */ 
/*     */   public Constructor getCalling()
/*     */   {
/*  97 */     return this.wrapped.getCalling();
/*     */   }
/*     */ 
/*     */   public Method getCalledMethod()
/*     */   {
/* 102 */     return this.wrapped.getCalledMethod();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 107 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 112 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 117 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 122 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 127 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 132 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/* 137 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/* 142 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 147 */     MethodCalledByConstructorInvocationWrapper invocation = new MethodCalledByConstructorInvocationWrapper((MethodCalledByConstructorInvocation)this.wrapped.copy(), this.interceptors);
/* 148 */     invocation.currentInterceptor = this.currentInterceptor;
/* 149 */     return invocation;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodCalledByConstructorInvocationWrapper
 * JD-Core Version:    0.6.0
 */