/*     */ package org.jboss.aop.joinpoint;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.MethodByMethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ 
/*     */ public class MethodCalledByMethodInvocation extends CallerInvocation
/*     */ {
/*     */   private static final long serialVersionUID = -156920151151728318L;
/*     */   Class callingClass;
/*     */   Method callingMethod;
/*     */   Method method;
/*     */ 
/*     */   public MethodCalledByMethodInvocation(MethodByMethodInfo info, Object callingObject, Object targetObject, Object[] arguments, Interceptor[] interceptors)
/*     */   {
/*  51 */     this(info.getAdvisor(), info.getCallingClass(), info.getCallingMethod(), info.getMethod(), callingObject, targetObject, arguments, interceptors);
/*     */   }
/*     */ 
/*     */   public MethodCalledByMethodInvocation(MethodByMethodInfo info, Object callingObject, Object targetObject, Interceptor[] interceptors)
/*     */   {
/*  56 */     this(info.getAdvisor(), info.getCallingClass(), info.getCallingMethod(), info.getMethod(), callingObject, targetObject, null, interceptors);
/*     */   }
/*     */ 
/*     */   public MethodCalledByMethodInvocation(Advisor advisor, Class callingClass, Method callingMethod, Method method, Object callingObject, Object targetObject, Object[] args, Interceptor[] interceptors)
/*     */   {
/*  62 */     super(advisor, callingObject, interceptors);
/*  63 */     this.callingClass = callingClass;
/*  64 */     this.callingMethod = callingMethod;
/*  65 */     this.method = method;
/*  66 */     setTargetObject(targetObject);
/*  67 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public MethodCalledByMethodInvocation(Object callingObject, Interceptor[] interceptors)
/*     */   {
/*  72 */     super(callingObject, interceptors);
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  82 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  86 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  95 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public Object invokeTarget()
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 106 */       return this.method.invoke(getTargetObject(), this.arguments);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 110 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object group, Object attr)
/*     */   {
/* 126 */     Object val = super.getMetaData(group, attr);
/* 127 */     if (val != null) return val;
/*     */ 
/* 130 */     return null;
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 144 */     MethodCalledByMethodInvocationWrapper wrapper = new MethodCalledByMethodInvocationWrapper(this, newchain);
/* 145 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 155 */     MethodCalledByMethodInvocation wrapper = new MethodCalledByMethodInvocation(this.advisor, this.callingClass, this.callingMethod, this.method, this.callingObject, this.targetObject, this.arguments, this.interceptors);
/*     */ 
/* 157 */     wrapper.currentInterceptor = this.currentInterceptor;
/* 158 */     wrapper.instanceResolver = this.instanceResolver;
/* 159 */     wrapper.metadata = this.metadata;
/* 160 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public Class getCallingClass()
/*     */   {
/* 168 */     return this.callingClass;
/*     */   }
/*     */ 
/*     */   public Method getCallingMethod()
/*     */   {
/* 176 */     return this.callingMethod;
/*     */   }
/*     */ 
/*     */   public Method getCalledMethod()
/*     */   {
/* 181 */     return this.method;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.joinpoint.MethodCalledByMethodInvocation
 * JD-Core Version:    0.6.0
 */