/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Iterator;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.util.XmlHelper;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ConstructorConfig
/*     */ {
/*  52 */   String signature = null;
/*     */ 
/*     */   public boolean patternMatches(Constructor constructor)
/*     */   {
/*  63 */     if (this.signature.equals("*"))
/*     */     {
/*  65 */       return true;
/*     */     }
/*     */ 
/*  68 */     String sig = MethodConfig.getSignature(constructor.getParameterTypes());
/*  69 */     return sig.equals(this.signature);
/*     */   }
/*     */ 
/*     */   public boolean patternMatches(CtConstructor constructor)
/*     */     throws NotFoundException
/*     */   {
/*  75 */     if (this.signature.equals("*"))
/*     */     {
/*  77 */       return true;
/*     */     }
/*     */ 
/*  80 */     String sig = MethodConfig.getSignature(constructor.getParameterTypes());
/*  81 */     return sig.equals(this.signature);
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws Exception
/*     */   {
/*  90 */     Element paramsElement = XmlHelper.getOptionalChild(element, "constructor-params");
/*  91 */     if (paramsElement == null)
/*     */     {
/*  93 */       String content = XmlHelper.getElementContent(element);
/*  94 */       if ((content == null) || (!content.equals("*"))) throw new RuntimeException("Empty <constructor> element must have at least an empty <constructor-params> element");
/*  95 */       this.signature = "*";
/*  96 */       return;
/*     */     }
/*  98 */     this.signature = "(";
/*  99 */     Iterator paramsIterator = XmlHelper.getChildrenByTagName(paramsElement, "constructor-param");
/*     */ 
/* 101 */     while (paramsIterator.hasNext())
/*     */     {
/* 103 */       this.signature += XmlHelper.getElementContent((Element)paramsIterator.next()).trim();
/* 104 */       this.signature += " ";
/*     */     }
/* 106 */     this.signature += ")";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.ConstructorConfig
 * JD-Core Version:    0.6.0
 */