/*     */ package org.jboss.aop.metadata;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javassist.CtConstructor;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ 
/*     */ public class ConstructorMetaData
/*     */   implements MetaDataResolver
/*     */ {
/*  39 */   HashMap constructorMetaData = new HashMap();
/*     */ 
/*     */   public boolean hasTag(String tag)
/*     */   {
/*  43 */     Iterator values = this.constructorMetaData.values().iterator();
/*  44 */     while (values.hasNext())
/*     */     {
/*  46 */       SimpleMetaData map = (SimpleMetaData)values.next();
/*  47 */       if (map.hasTag(tag)) return true;
/*     */     }
/*  49 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasTag(Constructor constructor, String tag) {
/*  53 */     SimpleMetaData meta = getConstructorMetaData(constructor);
/*  54 */     if (meta == null) return false;
/*  55 */     return meta.hasTag(tag);
/*     */   }
/*     */ 
/*     */   public void tagConstructor(Constructor con, Object tag)
/*     */   {
/*  60 */     addConstructorMetaData(con, tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public void addConstructorMetaData(Constructor constructor, Object tag, Object attr, Object value)
/*     */   {
/*  65 */     addConstructorMetaData(constructor.toString(), tag, attr, value, PayloadKey.MARSHALLED);
/*     */   }
/*     */ 
/*     */   public void addConstructorMetaData(Constructor constructor, Object tag, Object attr, Object value, PayloadKey type) {
/*  69 */     addConstructorMetaData(constructor.toString(), tag, attr, value, type);
/*     */   }
/*     */ 
/*     */   public synchronized void addConstructorMetaData(String key, Object tag, Object attr, Object value, PayloadKey type) {
/*  73 */     SimpleMetaData constructorData = (SimpleMetaData)this.constructorMetaData.get(key);
/*  74 */     if (constructorData == null)
/*     */     {
/*  76 */       constructorData = new SimpleMetaData();
/*  77 */       this.constructorMetaData.put(key, constructorData);
/*     */     }
/*  79 */     constructorData.addMetaData(tag, attr, value, type);
/*     */   }
/*     */ 
/*     */   public synchronized Iterator getConstructors()
/*     */   {
/*  84 */     return this.constructorMetaData.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public synchronized SimpleMetaData getConstructorMetaData(Constructor constructor)
/*     */   {
/*  89 */     return (SimpleMetaData)this.constructorMetaData.get(constructor.toString());
/*     */   }
/*     */ 
/*     */   public synchronized SimpleMetaData getConstructorMetaData(String constructor)
/*     */   {
/*  94 */     return (SimpleMetaData)this.constructorMetaData.get(constructor);
/*     */   }
/*     */ 
/*     */   public synchronized Object getConstructorMetaData(Constructor constructor, Object tag, Object attr)
/*     */   {
/*  99 */     SimpleMetaData constructorData = (SimpleMetaData)this.constructorMetaData.get(constructor.toString());
/* 100 */     if (constructorData == null) return null;
/* 101 */     return constructorData.getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized Object getConstructorMetaData(String constructor, Object tag, Object attr)
/*     */   {
/* 106 */     SimpleMetaData constructorData = (SimpleMetaData)this.constructorMetaData.get(constructor);
/* 107 */     if (constructorData == null) return null;
/* 108 */     return constructorData.getMetaData(tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 113 */     this.constructorMetaData.clear();
/*     */   }
/*     */ 
/*     */   public Object resolve(Invocation invocation, Object tag, Object attr)
/*     */   {
/* 118 */     Constructor constructor = ((ConstructorInvocation)invocation).getConstructor();
/* 119 */     return getConstructorMetaData(constructor, tag, attr);
/*     */   }
/*     */ 
/*     */   public synchronized SimpleMetaData getAllMetaData(Invocation invocation)
/*     */   {
/* 124 */     Constructor constructor = ((ConstructorInvocation)invocation).getConstructor();
/* 125 */     return (SimpleMetaData)this.constructorMetaData.get(constructor);
/*     */   }
/*     */ 
/*     */   public void tagConstructor(CtConstructor con, Object tag)
/*     */   {
/* 132 */     addConstructorMetaData(con, tag, "$tagged$", new Object());
/*     */   }
/*     */ 
/*     */   public void addConstructorMetaData(CtConstructor constructor, Object tag, Object attr, Object value)
/*     */   {
/* 137 */     addConstructorMetaData(constructor.getSignature(), tag, attr, value, PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasGroup(CtConstructor constructor, String tag)
/*     */   {
/* 142 */     SimpleMetaData meta = (SimpleMetaData)this.constructorMetaData.get(constructor.getSignature());
/* 143 */     if (meta == null) return false;
/* 144 */     return meta.hasTag(tag);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.ConstructorMetaData
 * JD-Core Version:    0.6.0
 */