/*    */ package org.jboss.aop.metadata;
/*    */ 
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.util.PayloadKey;
/*    */ 
/*    */ public class ThreadMetaData
/*    */   implements MetaDataResolver
/*    */ {
/* 40 */   ThreadLocal metaData = new ThreadLocal();
/*    */ 
/* 94 */   private static final ThreadMetaData me = new ThreadMetaData();
/*    */ 
/*    */   public void addMetaData(Object tag, Object attr, Object value)
/*    */   {
/* 44 */     addMetaData(tag, attr, value, PayloadKey.MARSHALLED);
/*    */   }
/*    */ 
/*    */   public void addMetaData(Object tag, Object attr, Object value, PayloadKey type)
/*    */   {
/* 49 */     SimpleMetaData data = (SimpleMetaData)this.metaData.get();
/* 50 */     if (data == null)
/*    */     {
/* 52 */       data = new SimpleMetaData();
/* 53 */       this.metaData.set(data);
/*    */     }
/* 55 */     data.addMetaData(tag, attr, value, type);
/*    */   }
/*    */ 
/*    */   public Object getMetaData(Object tag, Object attr)
/*    */   {
/* 60 */     SimpleMetaData data = (SimpleMetaData)this.metaData.get();
/* 61 */     if (data == null) return null;
/* 62 */     return data.getMetaData(tag, attr);
/*    */   }
/*    */ 
/*    */   public synchronized void removeMetaData(Object tag, Object attr)
/*    */   {
/* 67 */     SimpleMetaData data = (SimpleMetaData)this.metaData.get();
/* 68 */     if (data == null) return;
/* 69 */     data.removeMetaData(tag, attr);
/*    */   }
/*    */ 
/*    */   public synchronized void removeGroupData(Object tag)
/*    */   {
/* 74 */     SimpleMetaData data = (SimpleMetaData)this.metaData.get();
/* 75 */     if (data == null) return;
/* 76 */     data.removeGroupData(tag);
/*    */   }
/*    */ 
/*    */   public Object resolve(Invocation invocation, Object tag, Object attr)
/*    */   {
/* 81 */     return getMetaData(tag, attr);
/*    */   }
/*    */ 
/*    */   public SimpleMetaData getAllMetaData(Invocation invocation)
/*    */   {
/* 86 */     return (SimpleMetaData)this.metaData.get();
/*    */   }
/*    */ 
/*    */   public void clear() {
/* 90 */     this.metaData.set(null);
/*    */   }
/*    */ 
/*    */   public static ThreadMetaData instance()
/*    */   {
/* 95 */     return me;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.metadata.ThreadMetaData
 * JD-Core Version:    0.6.0
 */