/*    */ package org.jboss.aop.microcontainer.aspects;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ public abstract class AbstractIntroduction<T extends Annotation>
/*    */   implements Interceptor
/*    */ {
/*    */   public String getName()
/*    */   {
/* 41 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   protected abstract Class<T> getBindingAnnotation();
/*    */ 
/*    */   protected boolean isBindingInfoPresent(Invocation invocation) {
/* 48 */     return invocation.resolveClassAnnotation(getBindingAnnotation()) != null;
/*    */   }
/*    */ 
/*    */   protected T resolveBindingInfo(Invocation invocation)
/*    */   {
/* 53 */     Class bindingClass = getBindingAnnotation();
/* 54 */     Object bindingInfo = invocation.resolveClassAnnotation(bindingClass);
/* 55 */     return (Annotation)bindingClass.cast(bindingInfo);
/*    */   }
/*    */ 
/*    */   protected void onRegistration(Invocation invocation, KernelControllerContext context)
/*    */   {
/* 60 */     onRegistration(context, resolveBindingInfo(invocation));
/*    */   }
/*    */ 
/*    */   protected void onRegistration(KernelControllerContext context, T annotation)
/*    */   {
/*    */   }
/*    */ 
/*    */   protected void onUnregistration(Invocation invocation, KernelControllerContext context)
/*    */   {
/* 69 */     onUnregistration(context, resolveBindingInfo(invocation));
/*    */   }
/*    */ 
/*    */   protected void onUnregistration(KernelControllerContext context, T annotation)
/*    */   {
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 78 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 79 */     KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
/* 80 */     String methodName = mi.getMethod().getName();
/* 81 */     boolean infoPresent = isBindingInfoPresent(invocation);
/*    */ 
/* 83 */     if (("setKernelControllerContext".equals(methodName)) && (infoPresent))
/*    */     {
/* 85 */       onRegistration(invocation, context);
/*    */     }
/* 87 */     else if (infoPresent)
/*    */     {
/* 89 */       onUnregistration(invocation, context);
/*    */     }
/*    */ 
/* 92 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.aspects.AbstractIntroduction
 * JD-Core Version:    0.6.0
 */