/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class IntroductionBinding
/*     */ {
/*     */   protected AspectManager manager;
/*  42 */   protected String name = GUID.asString();
/*     */   protected String classes;
/*     */   protected String expr;
/*     */   protected List<String> interfaces;
/*     */   protected List<MixinEntry> mixins;
/*     */ 
/*     */   public List<String> getInterfaces()
/*     */   {
/*  60 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public void setInterfaces(List<String> interfaces)
/*     */   {
/*  70 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public List<MixinEntry> getMixins()
/*     */   {
/*  75 */     return this.mixins;
/*     */   }
/*     */ 
/*     */   public void setMixins(List<MixinEntry> mixins)
/*     */   {
/*  80 */     this.mixins = mixins;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  85 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  90 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getClasses()
/*     */   {
/* 100 */     return this.classes;
/*     */   }
/*     */ 
/*     */   public void setClasses(String classes)
/*     */   {
/* 110 */     this.classes = classes;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/* 115 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String expr)
/*     */   {
/* 120 */     this.expr = expr;
/*     */   }
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/* 130 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/* 140 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 145 */     if (this.manager == null)
/* 146 */       throw new IllegalArgumentException("Null manager");
/* 147 */     if ((this.classes == null) && (this.expr == null))
/* 148 */       throw new IllegalArgumentException("Neither classes nor expr set");
/* 149 */     if ((this.classes != null) && (this.expr != null))
/* 150 */       throw new IllegalArgumentException("Cannot set both classes and expr");
/* 151 */     if ((this.interfaces == null) && (this.mixins == null)) {
/* 152 */       throw new IllegalArgumentException("Neither interfaces nor mixins set");
/*     */     }
/* 154 */     String[] intfs = this.interfaces != null ? (String[])this.interfaces.toArray(new String[this.interfaces.size()]) : null;
/*     */ 
/* 156 */     InterfaceIntroduction introduction = null;
/* 157 */     if (this.classes != null)
/*     */     {
/* 159 */       introduction = new InterfaceIntroduction(this.name, this.classes, intfs);
/*     */     }
/*     */     else
/*     */     {
/* 163 */       ASTStart start = new TypeExpressionParser(new StringReader(this.expr)).Start();
/* 164 */       introduction = new InterfaceIntroduction(this.name, start, intfs);
/*     */     }
/*     */ 
/* 167 */     if (this.mixins != null)
/*     */     {
/* 169 */       for (MixinEntry entry : this.mixins)
/*     */       {
/* 171 */         if (entry.getInterfaces() == null)
/* 172 */           throw new IllegalArgumentException("MixinEntry with null interfaces");
/* 173 */         if (entry.getMixin() == null)
/* 174 */           throw new IllegalArgumentException("MixinEntry with null mixin");
/* 175 */         String[] intfaces = (String[])entry.getInterfaces().toArray(new String[entry.getInterfaces().size()]);
/*     */ 
/* 177 */         introduction.addMixin(new InterfaceIntroduction.Mixin(entry.getMixin(), intfaces, entry.getConstruction(), entry.isTransient()));
/*     */       }
/*     */     }
/* 180 */     this.manager.addInterfaceIntroduction(introduction);
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 185 */     this.manager.removeInterfaceIntroduction(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.IntroductionBinding
 * JD-Core Version:    0.6.0
 */