/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.beanmetadatafactory.BeanMetaDataUtil;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ 
/*     */ public abstract class LifecycleBeanMetaDataFactory extends GenericBeanFactoryMetaData
/*     */   implements BeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String classes;
/*     */   private String expr;
/*     */   private String installMethod;
/*     */   private String uninstallMethod;
/*  54 */   BeanMetaDataUtil util = new BeanMetaDataUtil();
/*  55 */   HashSet<PropertyMetaData> properties = new HashSet();
/*     */ 
/*     */   public void setManagerBean(String managerBean)
/*     */   {
/*  59 */     this.util.setManagerBean(managerBean);
/*     */   }
/*     */ 
/*     */   public void setManagerProperty(String aspectManagerProperty)
/*     */   {
/*  64 */     this.util.setManagerProperty(aspectManagerProperty);
/*     */   }
/*     */ 
/*     */   public void setClasses(String classes)
/*     */   {
/*  69 */     this.classes = classes;
/*     */   }
/*     */ 
/*     */   public void setExpr(String classes)
/*     */   {
/*  74 */     this.expr = classes;
/*     */   }
/*     */ 
/*     */   public void setInstallMethod(String installMethod)
/*     */   {
/*  79 */     this.installMethod = installMethod;
/*     */   }
/*     */ 
/*     */   public void setUninstallMethod(String uninstallMethod)
/*     */   {
/*  84 */     this.uninstallMethod = uninstallMethod;
/*     */   }
/*     */ 
/*     */   protected abstract ControllerState getState();
/*     */ 
/*     */   public List<BeanMetaData> getBeans() {
/*  91 */     ArrayList result = new ArrayList();
/*     */ 
/*  94 */     AbstractBeanMetaData lifecycle = new AbstractBeanMetaData();
/*  95 */     lifecycle.setName(this.name);
/*  96 */     lifecycle.setBean(getBeanClass());
/*  97 */     for (PropertyMetaData pmd : this.properties)
/*     */     {
/*  99 */       lifecycle.addProperty(pmd);
/*     */     }
/* 101 */     lifecycle.setDepends(getDepends());
/* 102 */     result.add(lifecycle);
/*     */ 
/* 105 */     String aspectBindingName = this.name + "$AspectBinding";
/* 106 */     AbstractBeanMetaData aspectBinding = new AbstractBeanMetaData();
/* 107 */     aspectBinding.setName(aspectBindingName);
/* 108 */     aspectBinding.setBean(LifecycleBinding.class.getName());
/*     */ 
/* 110 */     BeanMetaDataUtil.setSimpleProperty(aspectBinding, "callbackBean", this.name);
/* 111 */     this.util.setAspectManagerProperty(aspectBinding, "manager");
/* 112 */     if (this.expr != null)
/*     */     {
/* 114 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "expr", this.expr);
/*     */     }
/* 116 */     else if (this.classes != null)
/*     */     {
/* 118 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "classes", this.classes);
/*     */     }
/* 120 */     BeanMetaDataUtil.setSimpleProperty(aspectBinding, "state", getState());
/* 121 */     if (this.installMethod != null)
/*     */     {
/* 123 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "installMethod", this.installMethod);
/*     */     }
/* 125 */     if (this.uninstallMethod != null)
/*     */     {
/* 127 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "uninstallMethod", this.uninstallMethod);
/*     */     }
/* 129 */     result.add(aspectBinding);
/*     */ 
/* 131 */     return result;
/*     */   }
/*     */ 
/*     */   protected boolean hasInjectedBeans()
/*     */   {
/* 137 */     ArrayList dependencies = new ArrayList();
/* 138 */     getDependencies(dependencies, this);
/*     */ 
/* 140 */     for (AbstractDependencyValueMetaData dep : dependencies)
/*     */     {
/* 142 */       if (!((String)dep.getValue()).startsWith("jboss.kernel:service="))
/*     */       {
/* 144 */         return true;
/*     */       }
/*     */     }
/* 147 */     return false;
/*     */   }
/*     */ 
/*     */   private void getDependencies(ArrayList<AbstractDependencyValueMetaData> dependencies, MetaDataVisitorNode node)
/*     */   {
/* 152 */     Iterator children = node.getChildren();
/*     */ 
/* 154 */     if (children != null)
/*     */     {
/* 156 */       while (children.hasNext())
/*     */       {
/* 158 */         MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
/* 159 */         if ((child instanceof AbstractDependencyValueMetaData))
/*     */         {
/* 161 */           dependencies.add((AbstractDependencyValueMetaData)child);
/*     */         }
/* 163 */         getDependencies(dependencies, child);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addBeanProperty(PropertyMetaData property)
/*     */   {
/* 171 */     this.properties.add(property);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.LifecycleBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */