/*     */ package org.jboss.aop.microcontainer.beans;
/*     */ 
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.Typedef;
/*     */ import org.jboss.aop.pointcut.TypedefExpression;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ 
/*     */ public class TypeDef
/*     */ {
/*     */   private AspectManager manager;
/*     */   private String name;
/*     */   private String expr;
/*     */ 
/*     */   public AspectManager getManager()
/*     */   {
/*  45 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  50 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  55 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  60 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  65 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String expr)
/*     */   {
/*  70 */     this.expr = expr;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  75 */     if (this.manager == null)
/*     */     {
/*  77 */       throw new IllegalArgumentException("No manager");
/*     */     }
/*  79 */     if ((this.name == null) || (this.name.length() == 0))
/*     */     {
/*  81 */       throw new IllegalArgumentException("No name");
/*     */     }
/*  83 */     if ((this.expr == null) || (this.expr.length() == 0))
/*     */     {
/*  85 */       throw new IllegalArgumentException("No expr");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  90 */       Typedef typedef = new TypedefExpression(this.name, this.expr);
/*  91 */       this.manager.addTypedef(typedef);
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/*  95 */       throw new IllegalArgumentException("");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  99 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 105 */     this.manager.removeTypedef(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.TypeDef
 * JD-Core Version:    0.6.0
 */