/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.ArrayBinding;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class ArrayBindBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   String name;
/*     */   String type;
/*  48 */   private List<BaseInterceptorData> interceptors = new ArrayList();
/*     */ 
/*     */   public ArrayBindBeanMetaDataFactory()
/*     */   {
/*  52 */     setBeanClass("IGNORED");
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  57 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/*  62 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  68 */     ArrayList result = new ArrayList();
/*     */ 
/*  71 */     AbstractBeanMetaData binding = new AbstractBeanMetaData();
/*  72 */     if (this.name == null)
/*     */     {
/*  74 */       this.name = GUID.asString();
/*     */     }
/*  76 */     binding.setName(this.name);
/*  77 */     BeanMetaDataUtil.setSimpleProperty(binding, "name", this.name);
/*  78 */     binding.setBean(ArrayBinding.class.getName());
/*  79 */     BeanMetaDataUtil.setSimpleProperty(binding, "type", this.type);
/*  80 */     this.util.setAspectManagerProperty(binding, "manager");
/*  81 */     result.add(binding);
/*     */     AbstractListMetaData almd;
/*     */     int i;
/*  83 */     if (this.interceptors.size() > 0)
/*     */     {
/*  85 */       almd = new AbstractListMetaData();
/*  86 */       i = 0;
/*  87 */       for (BaseInterceptorData interceptor : this.interceptors)
/*     */       {
/*  89 */         AbstractBeanMetaData bmd = new AbstractBeanMetaData(interceptor.getBeanClassName());
/*  90 */         String intName = this.name + "$" + i++;
/*  91 */         bmd.setName(intName);
/*  92 */         this.util.setAspectManagerProperty(bmd, "manager");
/*  93 */         BeanMetaDataUtil.DependencyBuilder builder = new BeanMetaDataUtil.DependencyBuilder(bmd, "binding", this.name).setState("Instantiated");
/*  94 */         BeanMetaDataUtil.setDependencyProperty(builder);
/*     */ 
/*  96 */         if ((interceptor instanceof AdviceData))
/*     */         {
/*  98 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "aspect", interceptor.getRefName());
/*  99 */           BeanMetaDataUtil.setDependencyProperty(db);
/* 100 */           if (((AdviceData)interceptor).getAdviceMethod() != null)
/*     */           {
/* 102 */             BeanMetaDataUtil.setSimpleProperty(bmd, "aspectMethod", ((AdviceData)interceptor).getAdviceMethod());
/*     */           }
/* 104 */           BeanMetaDataUtil.setSimpleProperty(bmd, "type", ((AdviceData)interceptor).getType());
/*     */         }
/*     */         else
/*     */         {
/* 108 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "stack", interceptor.getRefName());
/* 109 */           BeanMetaDataUtil.setDependencyProperty(db);
/*     */         }
/* 111 */         result.add(bmd);
/* 112 */         almd.add(new AbstractInjectionValueMetaData(intName));
/* 113 */         BeanMetaDataUtil.setSimpleProperty(binding, "advices", almd);
/*     */       }
/*     */     }
/*     */ 
/* 117 */     return result;
/*     */   }
/*     */ 
/*     */   public void addInterceptor(BaseInterceptorData interceptorData)
/*     */   {
/* 122 */     this.interceptors.add(interceptorData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.ArrayBindBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */