/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.Aspect;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.ThisValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ 
/*     */ public class AspectBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */   implements BeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  52 */   private String scope = "PER_VM";
/*     */   private String factory;
/*     */ 
/*     */   public void setScope(String scope)
/*     */   {
/*  58 */     this.scope = scope;
/*     */   }
/*     */ 
/*     */   public void setFactory(String clazz)
/*     */   {
/*  63 */     this.factory = clazz;
/*  64 */     if (getBeanClass() != null)
/*     */     {
/*  66 */       throw new RuntimeException("Cannot set both factory and clazz");
/*     */     }
/*     */ 
/*  69 */     super.setBeanClass(clazz);
/*     */   }
/*     */ 
/*     */   public void setBeanClass(String bean)
/*     */   {
/*  75 */     if (this.factory != null)
/*     */     {
/*  77 */       throw new RuntimeException("Cannot set both factory and clazz");
/*     */     }
/*  79 */     super.setBeanClass(bean);
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  85 */     ArrayList result = new ArrayList();
/*     */ 
/*  87 */     if (this.name == null)
/*     */     {
/*  89 */       this.name = super.getBeanClass();
/*     */     }
/*     */ 
/*  92 */     String aspectName = this.name;
/*     */ 
/*  94 */     this.name = ("Factory$" + this.name);
/*  95 */     result.add(this);
/*     */ 
/*  99 */     AbstractBeanMetaData aspect = new AbstractBeanMetaData();
/* 100 */     aspect.setName(aspectName);
/* 101 */     aspect.setBean(Aspect.class.getName());
/* 102 */     BeanMetaDataUtil.setSimpleProperty(aspect, "scope", this.scope);
/* 103 */     this.util.setAspectManagerProperty(aspect, "manager");
/* 104 */     if (this.factory != null)
/*     */     {
/* 106 */       BeanMetaDataUtil.setSimpleProperty(aspect, "factory", Boolean.TRUE);
/*     */     }
/* 108 */     result.add(aspect);
/*     */ 
/* 110 */     if (hasInjectedBeans())
/*     */     {
/* 112 */       configureWithDependencies(aspect);
/*     */     }
/*     */     else
/*     */     {
/* 116 */       configureNoDependencies(aspect);
/*     */     }
/*     */ 
/* 119 */     return result;
/*     */   }
/*     */ 
/*     */   private void configureWithDependencies(AbstractBeanMetaData aspect)
/*     */   {
/* 124 */     aspect.addProperty(new AbstractPropertyMetaData("adviceBean", this.name));
/*     */ 
/* 126 */     AbstractInstallMetaData installAspect = new AbstractInstallMetaData();
/* 127 */     installAspect.setBean(aspect.getName());
/* 128 */     installAspect.setMethodName("install");
/* 129 */     ArrayList parameters = new ArrayList();
/* 130 */     parameters.add(new AbstractParameterMetaData(new ThisValueMetaData()));
/* 131 */     installAspect.setParameters(parameters);
/*     */ 
/* 133 */     List installs = getInstalls();
/* 134 */     if (installs == null)
/* 135 */       installs = new ArrayList();
/* 136 */     installs.add(installAspect);
/* 137 */     setInstalls(installs);
/*     */ 
/* 139 */     AbstractInstallMetaData uninstallAspect = new AbstractInstallMetaData();
/* 140 */     uninstallAspect.setBean(aspect.getName());
/* 141 */     uninstallAspect.setMethodName("uninstall");
/*     */ 
/* 143 */     List uninstalls = getUninstalls();
/* 144 */     if (uninstalls == null)
/* 145 */       uninstalls = new ArrayList();
/* 146 */     uninstalls.add(uninstallAspect);
/* 147 */     setUninstalls(uninstalls);
/*     */   }
/*     */ 
/*     */   private void configureNoDependencies(AbstractBeanMetaData aspect)
/*     */   {
/* 153 */     aspect.addProperty(new AbstractPropertyMetaData("advice", new AbstractDependencyValueMetaData(this.name)));
/*     */   }
/*     */ 
/*     */   private boolean hasInjectedBeans()
/*     */   {
/* 159 */     ArrayList dependencies = new ArrayList();
/* 160 */     getDependencies(dependencies, this);
/*     */ 
/* 162 */     for (AbstractDependencyValueMetaData dep : dependencies)
/*     */     {
/* 164 */       if (!((String)dep.getValue()).startsWith("jboss.kernel:service="))
/*     */       {
/* 166 */         return true;
/*     */       }
/*     */     }
/* 169 */     return false;
/*     */   }
/*     */ 
/*     */   private void getDependencies(ArrayList<AbstractDependencyValueMetaData> dependencies, MetaDataVisitorNode node)
/*     */   {
/* 174 */     Iterator children = node.getChildren();
/*     */ 
/* 176 */     if (children != null)
/*     */     {
/* 178 */       while (children.hasNext())
/*     */       {
/* 180 */         MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
/* 181 */         if ((child instanceof AbstractDependencyValueMetaData))
/*     */         {
/* 183 */           dependencies.add((AbstractDependencyValueMetaData)child);
/*     */         }
/* 185 */         getDependencies(dependencies, child);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.AspectBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */