/*    */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.aop.microcontainer.beans.PrecedenceDef;
/*    */ import org.jboss.aop.microcontainer.beans.PrecedenceDefEntry;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class PrecedenceBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/* 43 */   private List<BaseInterceptorData> entries = new ArrayList();
/*    */ 
/*    */   public PrecedenceBeanMetaDataFactory()
/*    */   {
/* 47 */     setBeanClass("IGNORED");
/*    */   }
/*    */ 
/*    */   public List<BeanMetaData> getBeans()
/*    */   {
/* 54 */     ArrayList result = new ArrayList();
/*    */ 
/* 57 */     AbstractBeanMetaData precedence = new AbstractBeanMetaData(PrecedenceDef.class.getName());
/* 58 */     String name = getName();
/* 59 */     if (name == null)
/*    */     {
/* 61 */       name = GUID.asString();
/*    */     }
/* 63 */     precedence.setName(name);
/* 64 */     BeanMetaDataUtil.setSimpleProperty(precedence, "name", getName());
/* 65 */     this.util.setAspectManagerProperty(precedence, "manager");
/* 66 */     result.add(precedence);
/*    */ 
/* 68 */     AbstractListMetaData lmd = new AbstractListMetaData();
/* 69 */     lmd.setType(ArrayList.class.getName());
/* 70 */     BeanMetaDataUtil.setSimpleProperty(precedence, "entries", lmd);
/* 71 */     int i = 0;
/* 72 */     for (BaseInterceptorData entry : this.entries)
/*    */     {
/* 74 */       String entryName = name + "$" + i++;
/* 75 */       AbstractBeanMetaData entryBean = new AbstractBeanMetaData(PrecedenceDefEntry.class.getName());
/* 76 */       entryBean.setName(entryName);
/* 77 */       BeanMetaDataUtil.setSimpleProperty(entryBean, "aspectName", entry.getRefName());
/* 78 */       if ((entry instanceof AdviceData))
/*    */       {
/* 80 */         BeanMetaDataUtil.setSimpleProperty(entryBean, "aspectMethod", ((AdviceData)entry).getAdviceMethod());
/*    */       }
/* 82 */       lmd.add(new AbstractInjectionValueMetaData(entryName));
/* 83 */       result.add(entryBean);
/*    */     }
/*    */ 
/* 86 */     return result;
/*    */   }
/*    */ 
/*    */   public void addEntry(BaseInterceptorData interceptor)
/*    */   {
/* 91 */     this.entries.add(interceptor);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.PrecedenceBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */