/*     */ package org.jboss.aop.microcontainer.integration;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.LinkedHashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ReflectiveAspectBinder;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.microcontainer.beans.AspectManagerFactory;
/*     */ import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
/*     */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackDefinition;
/*     */ import org.jboss.aop.proxy.container.ContainerCache;
/*     */ import org.jboss.aop.util.Advisable;
/*     */ import org.jboss.aop.util.ClassInfoMethodHashing;
/*     */ import org.jboss.classadapter.plugins.dependency.AbstractDependencyBuilder;
/*     */ import org.jboss.classadapter.spi.ClassAdapter;
/*     */ import org.jboss.classadapter.spi.Dependency;
/*     */ import org.jboss.classadapter.spi.DependencyBuilderListItem;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.reflect.plugins.AnnotationValueFactory;
/*     */ import org.jboss.reflect.plugins.introspection.IntrospectionAnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.ArrayValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.StringValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.Value;
/*     */ 
/*     */ public class AOPDependencyBuilder extends AbstractDependencyBuilder
/*     */ {
/*  74 */   private static final String DEPENDENCY_CLASS_NAME = Dependency.class.getName();
/*     */   private static final String DEPENDENCY_NAME_ATTRIBUTE = "name";
/*  76 */   private static final IntrospectionAnnotationHelper helper = new IntrospectionAnnotationHelper();
/*     */ 
/*     */   public List<DependencyBuilderListItem> getDependencies(ClassAdapter classAdapter, MetaData metaData)
/*     */   {
/*  80 */     AspectManager manager = AspectManagerFactory.getAspectManager(metaData);
/*     */     try
/*     */     {
/*  83 */       ClassInfo classInfo = classAdapter.getClassInfo();
/*  84 */       String className = classInfo.getName();
/*  85 */       if (className != null)
/*     */       {
/*  87 */         ClassLoader loader = classAdapter.getClassLoader();
/*  88 */         if (loader == null)
/*     */         {
/*  90 */           loader = Thread.currentThread().getContextClassLoader();
/*     */         }
/*  92 */         Class clazz = loader.loadClass(className);
/*     */         Advisor advisor;
/*  95 */         synchronized (ContainerCache.mapLock)
/*     */         {
/*  97 */           ContainerCache cache = ContainerCache.initialise(manager, clazz, metaData, true);
/*  98 */           advisor = cache.getAdvisor();
/*     */         }
/* 100 */         ReflectiveAspectBinder binder = new ReflectiveAspectBinder(clazz, advisor);
/* 101 */         Set aspects = binder.getAspects();
/*     */ 
/* 103 */         ArrayList depends = new ArrayList();
/* 104 */         if ((aspects != null) && (aspects.size() > 0))
/*     */         {
/* 106 */           Iterator it = aspects.iterator();
/* 107 */           while (it.hasNext())
/*     */           {
/* 109 */             AspectDefinition def = (AspectDefinition)it.next();
/* 110 */             if ((def instanceof ManagedAspectDefinition))
/*     */             {
/* 112 */               depends.add(new AspectDependencyBuilderListItem(def.getName()));
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 117 */         Map lifecycleCallbacks = binder.getLifecycleCallbacks();
/*     */         Iterator i$;
/* 118 */         if ((lifecycleCallbacks != null) && (lifecycleCallbacks.size() > 0))
/*     */         {
/* 120 */           for (i$ = lifecycleCallbacks.entrySet().iterator(); i$.hasNext(); ) { states = (Map.Entry)i$.next();
/*     */ 
/* 122 */             for (LifecycleCallbackDefinition callback : (Set)states.getValue())
/*     */             {
/* 124 */               depends.add(new LifecycleAspectDependencyBuilderListItem(callback.getBean(), (ControllerState)states.getKey(), callback.getInstallMethod(), callback.getUninstallMethod()));
/*     */             }
/*     */           }
/*     */         }
/*     */         Map.Entry states;
/* 130 */         HashSet annotationDependencies = getAnnotationDependencies(classInfo, metaData);
/* 131 */         for (String dependency : annotationDependencies)
/*     */         {
/* 133 */           depends.add(new AnnotationDependencyBuilderListItem(dependency));
/*     */         }
/* 135 */         return depends;
/*     */       }
/* 137 */       return null;
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*     */     }
/* 142 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private HashSet<String> getAnnotationDependencies(ClassInfo classInfo, MetaData metaData)
/*     */   {
/*     */     try
/*     */     {
/* 150 */       HashSet dependencies = new LinkedHashSet();
/* 151 */       getClassAnnotationDependencies(classInfo, metaData, dependencies);
/* 152 */       getMethodAnnotationDependencies(classInfo, metaData, dependencies);
/* 153 */       return dependencies;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 157 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 161 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private void getClassAnnotationDependencies(ClassInfo classInfo, MetaData metaData, HashSet<String> dependencies)
/*     */     throws Exception
/*     */   {
/* 167 */     HashMap realMap = new LinkedHashMap();
/* 168 */     getRealClassAnnotationDependencies(classInfo, realMap);
/* 169 */     HashMap metaMap = new LinkedHashMap();
/* 170 */     getMetaDataClassAnnotationDependencies(metaData, metaMap);
/* 171 */     addAllDependenciesToSet(dependencies, realMap, metaMap);
/*     */   }
/*     */ 
/*     */   private void getRealClassAnnotationDependencies(ClassInfo classInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception
/*     */   {
/* 176 */     AnnotationValue[] annotations = classInfo.getAnnotations();
/*     */ 
/* 178 */     for (int i = 0; i < annotations.length; i++)
/*     */     {
/* 180 */       getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getMetaDataClassAnnotationDependencies(MetaData metaData, HashMap<String, ArrayList<String>> dependencies) throws Exception
/*     */   {
/* 186 */     if (metaData != null)
/*     */     {
/* 188 */       for (Object annotation : metaData.getAnnotations())
/*     */       {
/* 190 */         getDependenciesForMetaDataAnnotation(annotation, dependencies);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getMethodAnnotationDependencies(ClassInfo classInfo, MetaData metaData, HashSet<String> dependencies) throws Exception
/*     */   {
/* 197 */     Map methodMap = ClassInfoMethodHashing.getMethodMap(classInfo);
/*     */     Iterator it;
/* 198 */     if (methodMap != null)
/*     */     {
/* 200 */       for (it = methodMap.values().iterator(); it.hasNext(); )
/*     */       {
/* 202 */         MethodInfo method = (MethodInfo)it.next();
/* 203 */         if (Advisable.isAdvisableMethod(method.getModifiers(), method.getName()))
/*     */         {
/* 205 */           HashMap classMap = new LinkedHashMap();
/* 206 */           getRealMethodAnnotationDependencies(method, classMap);
/* 207 */           HashMap overrideMap = new LinkedHashMap();
/* 208 */           getMetaDataMethodAnnotationDependencies(method, metaData, overrideMap);
/* 209 */           addAllDependenciesToSet(dependencies, classMap, overrideMap);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getRealMethodAnnotationDependencies(MethodInfo methodInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception
/*     */   {
/* 217 */     AnnotationValue[] annotations = methodInfo.getAnnotations();
/* 218 */     if (annotations != null)
/*     */     {
/* 220 */       for (int i = 0; i < annotations.length; i++)
/*     */       {
/* 222 */         getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getMetaDataMethodAnnotationDependencies(MethodInfo method, MetaData metaData, HashMap<String, ArrayList<String>> dependencies) throws Exception
/*     */   {
/* 229 */     if (metaData != null)
/*     */     {
/* 231 */       MetaData methodMetaData = metaData.getComponentMetaData(new MethodSignature(method));
/* 232 */       if (methodMetaData != null)
/*     */       {
/* 234 */         for (Object annotation : methodMetaData.getAnnotations())
/*     */         {
/* 236 */           getDependenciesForMetaDataAnnotation(annotation, dependencies);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getDependenciesForMetaDataAnnotation(Object annotation, HashMap<String, ArrayList<String>> dependencies) throws Exception {
/* 245 */     Class clazz = annotation.getClass().getInterfaces()[0];
/*     */     AnnotationInfo info;
/*     */     try {
/* 248 */       info = (AnnotationInfo)helper.getTypeInfo(clazz);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 253 */       throw new RuntimeException("Error creating annotation for " + clazz.getName(), e);
/*     */     }
/* 255 */     AnnotationValue value = AnnotationValueFactory.createAnnotationValue(helper, helper, info, annotation);
/* 256 */     getDependenciesForAnnotation(info.getName(), value, dependencies);
/*     */   }
/*     */ 
/*     */   private void getDependenciesForAnnotation(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies)
/*     */   {
/* 261 */     if (annotation != null)
/*     */     {
/* 263 */       addAnnotationAttributeDependencies(topLevelAnnotationName, annotation, dependencies);
/*     */ 
/* 265 */       AnnotationValue[] annotationAnnotations = annotation.getAnnotationType().getAnnotations();
/* 266 */       for (int i = 0; i < annotationAnnotations.length; i++)
/*     */       {
/* 268 */         if (!annotationAnnotations[i].getAnnotationType().getName().equals(DEPENDENCY_CLASS_NAME))
/*     */           continue;
/* 270 */         StringValue value = (StringValue)annotationAnnotations[i].getValue("name");
/* 271 */         StringValue dependency = (StringValue)annotation.getValue(value.getValue());
/* 272 */         addDependency(topLevelAnnotationName, dependency, dependencies);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addAnnotationAttributeDependencies(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies)
/*     */   {
/* 280 */     MethodInfo[] attributes = annotation.getAnnotationType().getDeclaredMethods();
/* 281 */     if (attributes != null)
/*     */     {
/* 283 */       for (int i = 0; i < attributes.length; i++)
/*     */       {
/* 285 */         Value value = annotation.getValue(attributes[i].getName());
/*     */ 
/* 287 */         if ((value instanceof AnnotationValue))
/*     */         {
/* 289 */           getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)value, dependencies);
/*     */         } else {
/* 291 */           if (!(value instanceof ArrayValue))
/*     */             continue;
/* 293 */           ArrayValue arrVal = (ArrayValue)value;
/* 294 */           TypeInfo type = ((ArrayInfo)arrVal.getType()).getComponentType();
/* 295 */           if (!(type instanceof AnnotationInfo))
/*     */             continue;
/* 297 */           Value[] values = arrVal.getValues();
/* 298 */           for (int j = 0; j < values.length; j++)
/*     */           {
/* 300 */             getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)values[j], dependencies);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addDependency(String topLevelAnnotationName, StringValue dependency, HashMap<String, ArrayList<String>> dependencies)
/*     */   {
/* 310 */     ArrayList list = (ArrayList)dependencies.get(topLevelAnnotationName);
/* 311 */     if (list == null)
/*     */     {
/* 313 */       list = new ArrayList();
/* 314 */       dependencies.put(topLevelAnnotationName, list);
/*     */     }
/*     */ 
/* 317 */     list.add(dependency.getValue());
/*     */   }
/*     */ 
/*     */   private void addAllDependenciesToSet(HashSet<String> dependencies, HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap)
/*     */   {
/* 322 */     HashMap dependencyMap = mergeClassAndOverrideMaps(classMap, overrideMap);
/* 323 */     if (dependencyMap.size() > 0)
/*     */     {
/* 325 */       for (ArrayList deps : dependencyMap.values())
/*     */       {
/* 327 */         dependencies.addAll(deps);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private HashMap<String, ArrayList<String>> mergeClassAndOverrideMaps(HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap)
/*     */   {
/* 334 */     if ((classMap.size() == 0) && (overrideMap.size() == 0))
/*     */     {
/* 336 */       return classMap;
/*     */     }
/* 338 */     if ((classMap.size() > 0) && (overrideMap.size() == 0))
/*     */     {
/* 340 */       return classMap;
/*     */     }
/* 342 */     if ((classMap.size() == 0) && (overrideMap.size() > 0))
/*     */     {
/* 344 */       return overrideMap;
/*     */     }
/*     */ 
/* 347 */     for (String key : overrideMap.keySet())
/*     */     {
/* 349 */       classMap.put(key, overrideMap.get(key));
/*     */     }
/* 351 */     return classMap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.integration.AOPDependencyBuilder
 * JD-Core Version:    0.6.0
 */