/*    */ package org.jboss.aop.microcontainer.integration;
/*    */ 
/*    */ import org.jboss.dependency.plugins.AbstractLifecycleCallbackItem;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ class LifecycleAspectDependencyBuilderListItem extends AspectDependencyBuilderListItem
/*    */ {
/*    */   ControllerState state;
/*    */   String installMethod;
/*    */   String uninstallMethod;
/*    */ 
/*    */   LifecycleAspectDependencyBuilderListItem(String beanName, ControllerState state, String installMethod, String uninstallMethod)
/*    */   {
/* 42 */     super(beanName);
/* 43 */     this.state = state;
/* 44 */     this.installMethod = installMethod;
/* 45 */     this.uninstallMethod = uninstallMethod;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 50 */     if (super.equals(o))
/*    */     {
/* 52 */       if ((o instanceof LifecycleAspectDependencyBuilderListItem))
/*    */       {
/* 54 */         return this.state.equals(((LifecycleAspectDependencyBuilderListItem)o).state);
/*    */       }
/*    */     }
/* 57 */     return false;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 62 */     return this.dependencyName.hashCode();
/*    */   }
/*    */ 
/*    */   public void addDependency(KernelControllerContext context)
/*    */   {
/* 67 */     AbstractLifecycleCallbackItem callback = new AbstractLifecycleCallbackItem(this.dependencyName, this.state, ControllerState.INSTALLED, this.installMethod, this.uninstallMethod);
/* 68 */     DependencyInfo di = context.getDependencyInfo();
/* 69 */     di.addLifecycleCallback(callback);
/*    */ 
/* 71 */     super.addDependency(context);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.integration.LifecycleAspectDependencyBuilderListItem
 * JD-Core Version:    0.6.0
 */