/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTAllParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTAnd;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTClass;
/*     */ import org.jboss.aop.pointcut.ast.ASTComposite;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTException;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTNot;
/*     */ import org.jboss.aop.pointcut.ast.ASTOr;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTSub;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;
/*     */ 
/*     */ public class AnnotationMatcher
/*     */   implements TypeExpressionParserVisitor
/*     */ {
/*     */   private Advisor advisor;
/*     */   private Object element;
/*     */ 
/*     */   public AnnotationMatcher(Advisor advisor, Object element)
/*     */   {
/*  69 */     this.advisor = advisor;
/*  70 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/*  75 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBoolean node, Object data)
/*     */   {
/*  80 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTComposite node, Object data)
/*     */   {
/*  85 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/*  91 */     Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
/*  92 */     boolean val = bool.booleanValue();
/*  93 */     return val ? Boolean.FALSE : Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSub node, Object data)
/*     */   {
/*  98 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 100 */       data = node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 102 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object left)
/*     */   {
/* 107 */     Node andChild = node.jjtGetChild(0);
/* 108 */     boolean val = ((Boolean)left).booleanValue();
/* 109 */     return new Boolean((val) && (((Boolean)andChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object left)
/*     */   {
/* 114 */     Node orChild = node.jjtGetChild(0);
/* 115 */     boolean val = ((Boolean)left).booleanValue();
/* 116 */     return new Boolean((val) || (((Boolean)orChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   public CtClass getDeclaringClass()
/*     */   {
/* 127 */     if ((this.element instanceof CtClass)) return (CtClass)this.element;
/* 128 */     if ((this.element instanceof CtMethod)) return ((CtMethod)this.element).getDeclaringClass();
/* 129 */     if ((this.element instanceof CtField)) return ((CtField)this.element).getDeclaringClass();
/* 130 */     if ((this.element instanceof CtConstructor)) return ((CtConstructor)this.element).getDeclaringClass();
/* 131 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getJavaDeclaringClass()
/*     */   {
/* 136 */     if ((this.element instanceof Class)) return (Class)this.element;
/* 137 */     if ((this.element instanceof Method)) return ((Method)this.element).getDeclaringClass();
/* 138 */     if ((this.element instanceof Field)) return ((Field)this.element).getDeclaringClass();
/* 139 */     if ((this.element instanceof Constructor)) return ((Constructor)this.element).getDeclaringClass();
/* 140 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 145 */     Node n = node.jjtGetChild(0);
/* 146 */     if (getDeclaringClass() != null)
/*     */     {
/* 148 */       CtClass clazz = getDeclaringClass();
/* 149 */       if ((n instanceof ASTMethod))
/*     */       {
/* 151 */         return new Boolean(Util.has(clazz, (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/* 155 */       return new Boolean(Util.has(clazz, (ASTConstructor)n, this.advisor));
/*     */     }
/*     */ 
/* 160 */     Class clazz = getJavaDeclaringClass();
/* 161 */     if ((n instanceof ASTMethod))
/*     */     {
/* 163 */       return new Boolean(Util.has(clazz, (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/* 167 */     return new Boolean(Util.has(clazz, (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 175 */     if (getDeclaringClass() != null)
/*     */     {
/* 177 */       CtClass clazz = getDeclaringClass();
/* 178 */       ASTField f = (ASTField)node.jjtGetChild(0);
/* 179 */       return new Boolean(Util.has(clazz, f, this.advisor));
/*     */     }
/*     */ 
/* 183 */     Class clazz = getJavaDeclaringClass();
/* 184 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 185 */     return new Boolean(Util.has(clazz, f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTClass node, Object data)
/*     */   {
/* 191 */     if ((!(this.element instanceof CtClass)) && (!(this.element instanceof Class))) return Boolean.FALSE;
/* 192 */     if ((this.element instanceof CtClass))
/*     */     {
/* 194 */       CtClass clazz = (CtClass)this.element;
/* 195 */       return new Boolean(Util.matchesClassExpr(node.getClazz(), clazz, this.advisor));
/*     */     }
/*     */ 
/* 199 */     Class clazz = (Class)this.element;
/* 200 */     return new Boolean(Util.matchesClassExpr(node.getClazz(), clazz, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 207 */     if ((!(this.element instanceof CtMethod)) && (!(this.element instanceof Method))) return Boolean.FALSE;
/* 208 */     if ((this.element instanceof CtMethod))
/*     */     {
/* 210 */       MethodMatcher methodMatcher = null;
/* 211 */       methodMatcher = new MethodMatcher(this.advisor, (CtMethod)this.element, null);
/* 212 */       return methodMatcher.matches(node);
/*     */     }
/*     */ 
/* 216 */     MethodMatcher methodMatcher = null;
/* 217 */     methodMatcher = new MethodMatcher(this.advisor, (Method)this.element, null);
/* 218 */     return methodMatcher.matches(node);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 224 */     if ((!(this.element instanceof CtConstructor)) && (!(this.element instanceof Constructor))) return Boolean.FALSE;
/* 225 */     if ((this.element instanceof CtConstructor))
/*     */     {
/* 227 */       ConstructorMatcher conMatcher = null;
/*     */       try
/*     */       {
/* 230 */         conMatcher = new ConstructorMatcher(this.advisor, (CtConstructor)this.element, null);
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 234 */         throw new RuntimeException(e);
/*     */       }
/* 236 */       return conMatcher.matches(node);
/*     */     }
/*     */ 
/* 240 */     ConstructorMatcher conMatcher = null;
/* 241 */     conMatcher = new ConstructorMatcher(this.advisor, (Constructor)this.element, null);
/* 242 */     return conMatcher.matches(node);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/* 249 */     if ((!(this.element instanceof CtField)) && (!(this.element instanceof Field))) return Boolean.FALSE;
/* 250 */     if ((this.element instanceof CtField))
/*     */     {
/* 252 */       FieldMatcher fieldMatcher = null;
/*     */       try
/*     */       {
/* 255 */         fieldMatcher = new FieldMatcher(this.advisor, (CtField)this.element, null);
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 259 */         throw new RuntimeException(e);
/*     */       }
/* 261 */       return node.jjtAccept(fieldMatcher, null);
/*     */     }
/*     */ 
/* 265 */     FieldMatcher fieldMatcher = null;
/* 266 */     fieldMatcher = new FieldMatcher(this.advisor, (Field)this.element, null);
/* 267 */     return node.jjtAccept(fieldMatcher, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data)
/*     */   {
/* 274 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 279 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 284 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTException node, Object data)
/*     */   {
/* 289 */     return Boolean.FALSE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.AnnotationMatcher
 * JD-Core Version:    0.6.0
 */