/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class ConstructorCallMatcher extends MatcherHelper
/*     */ {
/*     */   Advisor advisor;
/*     */   AccessibleObject within;
/*     */   Class calledClass;
/*     */   Constructor calledConstructor;
/*     */ 
/*     */   public ConstructorCallMatcher(Advisor advisor, AccessibleObject within, Class calledClass, Constructor calledCon, ASTStart start)
/*     */   {
/*  55 */     super(start, advisor.getManager());
/*  56 */     this.advisor = advisor;
/*  57 */     this.within = within;
/*  58 */     this.calledClass = calledClass;
/*  59 */     this.calledConstructor = calledCon;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/*     */     try
/*     */     {
/*  66 */       if (!(node.getBehavior() instanceof ASTConstructor)) return Boolean.FALSE;
/*  67 */       ASTConstructor astCon = (ASTConstructor)node.getBehavior();
/*  68 */       Advisor calledAdvisor = AspectManager.instance().getTempClassAdvisorIfNotExist(this.calledClass);
/*  69 */       ConstructorMatcher constructorMatcher = new ConstructorMatcher(calledAdvisor, this.calledConstructor, null);
/*  70 */       return constructorMatcher.matches(astCon);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  74 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  80 */     Node n = node.jjtGetChild(0);
/*  81 */     if ((n instanceof ASTMethod))
/*     */     {
/*  83 */       return new Boolean(Util.has(this.calledClass, (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/*  87 */     return new Boolean(Util.has(this.calledClass, (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/*  93 */     ASTField f = (ASTField)node.jjtGetChild(0);
/*  94 */     return new Boolean(Util.has(this.calledClass, f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/*  99 */     WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
/* 100 */     return node.jjtAccept(visitor, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 105 */     WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
/* 106 */     return node.jjtAccept(visitor, null);
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/* 111 */     return new Boolean(p.matchesCall(this.advisor, this.within, this.calledClass, this.calledConstructor));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ConstructorCallMatcher
 * JD-Core Version:    0.6.0
 */