/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ 
/*     */ public class JoinPointMatcher
/*     */ {
/*     */   Pointcut p;
/*     */ 
/*     */   public JoinPointMatcher(String expr)
/*     */     throws ParseException
/*     */   {
/*  51 */     this.p = new PointcutExpression("test", expr);
/*     */   }
/*     */ 
/*     */   public boolean matches(Invocation invocation)
/*     */   {
/*  56 */     if ((invocation instanceof MethodInvocation))
/*     */     {
/*  58 */       MethodInvocation mi = (MethodInvocation)invocation;
/*  59 */       PointcutMethodMatch pmatch = this.p.matchesExecution(mi.getAdvisor(), mi.getMethod());
/*  60 */       if (pmatch == null)
/*     */       {
/*  62 */         return false;
/*     */       }
/*  64 */       return pmatch.isMatch();
/*     */     }
/*  66 */     if ((invocation instanceof ConstructorInvocation))
/*     */     {
/*  68 */       ConstructorInvocation mi = (ConstructorInvocation)invocation;
/*  69 */       return this.p.matchesExecution(mi.getAdvisor(), mi.getConstructor());
/*     */     }
/*  71 */     if ((invocation instanceof FieldReadInvocation))
/*     */     {
/*  73 */       FieldReadInvocation mi = (FieldReadInvocation)invocation;
/*  74 */       return this.p.matchesGet(mi.getAdvisor(), mi.getField());
/*     */     }
/*  76 */     if ((invocation instanceof FieldWriteInvocation))
/*     */     {
/*  78 */       FieldWriteInvocation mi = (FieldWriteInvocation)invocation;
/*  79 */       return this.p.matchesSet(mi.getAdvisor(), mi.getField());
/*     */     }
/*  81 */     if ((invocation instanceof MethodCalledByMethodInvocation))
/*     */     {
/*  83 */       MethodCalledByMethodInvocation mi = (MethodCalledByMethodInvocation)invocation;
/*  84 */       return this.p.matchesCall(mi.getAdvisor(), mi.getCallingMethod(), mi.getCalledMethod().getDeclaringClass(), mi.getCalledMethod());
/*     */     }
/*  86 */     if ((invocation instanceof MethodCalledByConstructorInvocation))
/*     */     {
/*  88 */       MethodCalledByConstructorInvocation mi = (MethodCalledByConstructorInvocation)invocation;
/*  89 */       return this.p.matchesCall(mi.getAdvisor(), mi.getCalling(), mi.getCalledMethod().getDeclaringClass(), mi.getCalledMethod());
/*     */     }
/*  91 */     if ((invocation instanceof ConstructorCalledByConstructorInvocation))
/*     */     {
/*  93 */       ConstructorCalledByConstructorInvocation mi = (ConstructorCalledByConstructorInvocation)invocation;
/*  94 */       return this.p.matchesCall(mi.getAdvisor(), mi.getCallingConstructor(), mi.getCalledConstructor().getDeclaringClass(), mi.getCalledConstructor());
/*     */     }
/*  96 */     if ((invocation instanceof ConstructorCalledByMethodInvocation))
/*     */     {
/*  98 */       ConstructorCalledByMethodInvocation mi = (ConstructorCalledByMethodInvocation)invocation;
/*  99 */       return this.p.matchesCall(mi.getAdvisor(), mi.getCallingMethod(), mi.getCalledConstructor().getDeclaringClass(), mi.getCalledConstructor());
/*     */     }
/* 101 */     throw new RuntimeException("UNKNOWN JOINPOINT TYPE: " + invocation.getClass().getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.JoinPointMatcher
 * JD-Core Version:    0.6.0
 */