/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.IdentifierExpression;
/*     */ 
/*     */ public class MethodMatcher extends MatcherHelper
/*     */ {
/*     */   protected Advisor advisor;
/*     */   protected CtMethod ctMethod;
/*     */   protected Method refMethod;
/*     */   protected int methodModifiers;
/*     */   protected String classname;
/*     */   protected String methodName;
/*     */   protected Class matchedClass;
/*     */   protected int matchLevel;
/*     */   protected boolean isInstanceof;
/*     */ 
/*     */   public MethodMatcher(Advisor advisor, CtMethod method, ASTStart start)
/*     */   {
/*  57 */     super(start, advisor.getManager());
/*  58 */     this.advisor = advisor;
/*  59 */     this.start = start;
/*  60 */     this.methodModifiers = method.getModifiers();
/*  61 */     this.classname = method.getDeclaringClass().getName();
/*  62 */     this.ctMethod = method;
/*  63 */     this.methodName = this.ctMethod.getName();
/*     */   }
/*     */ 
/*     */   public MethodMatcher(Advisor advisor, Method method, ASTStart start)
/*     */   {
/*  68 */     super(start, advisor.getManager());
/*  69 */     this.advisor = advisor;
/*  70 */     this.start = start;
/*  71 */     this.methodModifiers = method.getModifiers();
/*  72 */     this.classname = method.getDeclaringClass().getName();
/*  73 */     this.refMethod = method;
/*  74 */     this.methodName = this.refMethod.getName();
/*     */   }
/*     */ 
/*     */   public Class getMatchedClass()
/*     */   {
/*  79 */     return this.matchedClass;
/*     */   }
/*     */ 
/*     */   public int getMatchLevel()
/*     */   {
/*  84 */     return this.matchLevel;
/*     */   }
/*     */ 
/*     */   public boolean isInstanceOf()
/*     */   {
/*  89 */     return this.isInstanceof;
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  94 */     throw new RuntimeException("SHOULD NOT BE CALLED");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/*  99 */     return matches(node);
/*     */   }
/*     */ 
/*     */   public Boolean matches(ASTMethod node)
/*     */   {
/* 104 */     if (!matchesModifiers(node)) return Boolean.FALSE;
/* 105 */     if (!matchesClass(node)) return Boolean.FALSE;
/* 106 */     if (!matchesIdentifier(node)) return Boolean.FALSE;
/* 107 */     if (!matchesExceptions(node)) return Boolean.FALSE;
/* 108 */     if (!matchesReturnType(node)) return Boolean.FALSE;
/* 109 */     if (!matchesParameters(node)) return Boolean.FALSE;
/*     */ 
/* 111 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 116 */     Boolean matches = Boolean.FALSE;
/* 117 */     ClassExpression expr = node.getClazz();
/*     */ 
/* 119 */     if (this.ctMethod != null)
/*     */     {
/* 121 */       return classMatchesAll(expr);
/*     */     }
/*     */ 
/* 125 */     Class declaringClass = MatcherStrategy.getMatcher(this.advisor).getDeclaringClass(this.advisor, this.refMethod);
/* 126 */     if (!this.advisor.chainOverridingForInheritedMethods())
/*     */     {
/* 128 */       matches = classMatchesAll(expr);
/*     */     }
/*     */     else
/*     */     {
/* 132 */       Class advisedClass = this.advisor.getClazz();
/* 133 */       this.matchedClass = advisedClass;
/* 134 */       while (this.matchedClass != null)
/*     */       {
/* 136 */         if (classMatchesAll(node.getClazz()).booleanValue())
/*     */         {
/* 138 */           if (node.getClazz().isInstanceOf())
/*     */           {
/* 140 */             this.isInstanceof = true;
/*     */           }
/* 142 */           return Boolean.TRUE;
/*     */         }
/*     */ 
/* 145 */         if (this.matchedClass == declaringClass)
/*     */         {
/*     */           break;
/*     */         }
/* 149 */         this.matchedClass = this.matchedClass.getSuperclass();
/* 150 */         this.matchLevel += 1;
/*     */       }
/*     */     }
/*     */ 
/* 154 */     return matches;
/*     */   }
/*     */ 
/*     */   public Boolean classMatchesAll(ClassExpression expr)
/*     */   {
/* 159 */     if (expr.isAnnotation())
/*     */     {
/* 161 */       String sub = expr.getOriginal().substring(1);
/* 162 */       if (this.ctMethod != null)
/*     */       {
/* 164 */         if (!this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub))
/*     */         {
/* 166 */           if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */           {
/* 168 */             if (!this.advisor.hasAnnotation(this.ctMethod, sub)) return Boolean.FALSE;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 174 */       else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub))
/*     */       {
/* 176 */         if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */         {
/*     */           try
/*     */           {
/* 180 */             if (!this.advisor.hasAnnotation(this.refMethod, sub)) return Boolean.FALSE;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 184 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 190 */     else if (expr.isInstanceOf())
/*     */     {
/* 192 */       if (this.ctMethod != null)
/*     */       {
/* 194 */         if (!Util.subtypeOf(this.ctMethod.getDeclaringClass(), expr, this.advisor)) return Boolean.FALSE;
/*     */       }
/* 196 */       else if (!Util.subtypeOf(this.refMethod.getDeclaringClass(), expr, this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 199 */     else if (expr.isTypedef())
/*     */     {
/* 201 */       if (this.ctMethod != null)
/*     */       {
/*     */         try
/*     */         {
/* 205 */           if (!Util.matchesTypedef(this.ctMethod.getDeclaringClass(), expr, this.advisor)) return Boolean.FALSE;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 209 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/* 212 */       else if (!Util.matchesTypedef(this.refMethod.getDeclaringClass(), expr, this.advisor)) return Boolean.FALSE;
/*     */     }
/* 214 */     else if (!expr.matches(this.classname))
/*     */     {
/* 216 */       return Boolean.FALSE;
/*     */     }
/*     */ 
/* 219 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   protected boolean matchesModifiers(ASTMethod node)
/*     */   {
/* 224 */     if (node.getAttributes().size() > 0)
/*     */     {
/* 226 */       for (int i = 0; i < node.getAttributes().size(); i++)
/*     */       {
/* 228 */         ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
/* 229 */         if (!Util.matchModifiers(attr, this.methodModifiers)) return false;
/*     */       }
/*     */     }
/* 232 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean matchesClass(ASTMethod node)
/*     */   {
/* 237 */     if (this.ctMethod != null)
/*     */     {
/* 239 */       if (!Util.matchesClassExpr(node.getClazz(), this.ctMethod.getDeclaringClass(), this.advisor)) return false;
/*     */     }
/*     */     else
/*     */     {
/* 243 */       Class declaringClass = MatcherStrategy.getMatcher(this.advisor).getDeclaringClass(this.advisor, this.refMethod);
/* 244 */       if (!this.advisor.chainOverridingForInheritedMethods())
/*     */       {
/* 246 */         if (Util.matchesClassExpr(node.getClazz(), declaringClass, this.advisor))
/*     */         {
/* 248 */           this.matchedClass = declaringClass;
/* 249 */           return true;
/*     */         }
/* 251 */         return false;
/*     */       }
/*     */ 
/* 255 */       Class advisedClass = this.advisor.getClazz();
/* 256 */       if (this.advisor.getClazz() == null)
/*     */       {
/* 258 */         throw new RuntimeException("Advisor is null");
/*     */       }
/* 260 */       this.matchedClass = advisedClass;
/* 261 */       while (this.matchedClass != null)
/*     */       {
/* 263 */         if (Util.matchesClassExpr(node.getClazz(), this.matchedClass, this.advisor))
/*     */         {
/* 265 */           if (node.getClazz().isInstanceOf())
/*     */           {
/* 267 */             this.isInstanceof = true;
/*     */           }
/* 269 */           return true;
/*     */         }
/*     */ 
/* 272 */         if (this.matchedClass == declaringClass)
/*     */         {
/*     */           break;
/*     */         }
/* 276 */         this.matchedClass = this.matchedClass.getSuperclass();
/* 277 */         this.matchLevel += 1;
/*     */       }
/* 279 */       return false;
/*     */     }
/*     */ 
/* 282 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean matchesIdentifier(ASTMethod node)
/*     */   {
/* 287 */     if (node.getMethodIdentifier().isAnnotation())
/*     */     {
/* 289 */       if (this.advisor == null) return false;
/* 290 */       String sub = node.getMethodIdentifier().getOriginal().substring(1);
/* 291 */       if (this.ctMethod != null)
/*     */       {
/* 293 */         if (!this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub))
/*     */         {
/* 295 */           if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */           {
/* 297 */             if (!this.advisor.hasAnnotation(this.ctMethod, sub)) return false;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 303 */       else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub))
/*     */       {
/* 305 */         if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */         {
/*     */           try
/*     */           {
/* 309 */             if (!this.advisor.hasAnnotation(this.refMethod, sub)) return false;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 313 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/* 319 */       if ((node.getMethodIdentifier().isImplements()) || (node.getMethodIdentifier().isImplementing()))
/*     */       {
/*     */         try
/*     */         {
/* 323 */           boolean exactSuper = node.getMethodIdentifier().isImplements();
/* 324 */           ClassExpression implemented = node.getMethodIdentifier().getImplementsExpression();
/* 325 */           if (this.ctMethod != null)
/*     */           {
/* 327 */             if (Util.methodExistsInSuperClassOrInterface(this.ctMethod, implemented, exactSuper))
/*     */             {
/* 329 */               return true;
/*     */             }
/*     */ 
/*     */           }
/* 334 */           else if (Util.methodExistsInSuperClassOrInterface(this.refMethod, implemented, exactSuper, this.advisor))
/*     */           {
/* 336 */             return true;
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 342 */           throw new RuntimeException(e);
/*     */         }
/* 344 */         return false;
/*     */       }
/*     */ 
/* 348 */       if (!node.getMethodIdentifier().matches(this.methodName)) return false;
/*     */     }
/* 350 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean matchesExceptions(ASTMethod node)
/*     */   {
/* 356 */     ArrayList nodeExceptions = node.getExceptions();
/* 357 */     if (nodeExceptions.size() > 0)
/*     */     {
/* 359 */       if (this.ctMethod != null)
/*     */       {
/*     */         try
/*     */         {
/* 363 */           if (!Util.matchExceptions(nodeExceptions, this.ctMethod.getExceptionTypes()))
/*     */           {
/* 365 */             return false;
/*     */           }
/*     */         }
/*     */         catch (NotFoundException e)
/*     */         {
/* 370 */           throw new RuntimeException(e);
/*     */         }
/*     */ 
/*     */       }
/* 375 */       else if (!Util.matchExceptions(nodeExceptions, this.refMethod.getExceptionTypes()))
/*     */       {
/* 377 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 381 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean matchesReturnType(ASTMethod node)
/*     */   {
/*     */     try
/*     */     {
/* 388 */       if (this.ctMethod != null)
/*     */       {
/* 390 */         if (!Util.matchesClassExpr(node.getReturnType(), this.ctMethod.getReturnType(), this.advisor)) return false;
/*     */ 
/*     */       }
/* 394 */       else if (!Util.matchesClassExpr(node.getReturnType(), this.refMethod.getReturnType(), this.advisor)) return false;
/*     */ 
/*     */     }
/*     */     catch (NotFoundException nfe)
/*     */     {
/* 399 */       throw new RuntimeException(nfe);
/*     */     }
/*     */ 
/* 402 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean matchesParameters(ASTMethod node)
/*     */   {
/* 407 */     if (this.ctMethod != null)
/*     */     {
/* 409 */       return Util.matchesParameters(this.advisor, node, this.ctMethod);
/*     */     }
/*     */ 
/* 413 */     return Util.matchesParameters(this.advisor, node, this.refMethod);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.MethodMatcher
 * JD-Core Version:    0.6.0
 */