/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class NewExprMatcher extends MatcherHelper
/*     */ {
/*     */   NewExpr call;
/*     */   Advisor advisor;
/*     */ 
/*     */   public NewExprMatcher(Advisor advisor, NewExpr call, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  54 */     super(start, advisor.getManager());
/*  55 */     this.advisor = advisor;
/*  56 */     this.call = call;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/*     */     try
/*     */     {
/*  63 */       if (!(node.getBehavior() instanceof ASTConstructor)) return Boolean.FALSE;
/*  64 */       ASTConstructor astCon = (ASTConstructor)node.getBehavior();
/*     */ 
/*  67 */       if (astCon.getClazz().isSimple())
/*     */       {
/*  69 */         if (!astCon.getClazz().matches(this.call.getClassName())) return Boolean.FALSE;
/*     */       }
/*  71 */       CtConstructor calledCon = this.call.getConstructor();
/*  72 */       ClassAdvisor calledAdvisor = AspectManager.instance().getTempClassAdvisor(calledCon.getDeclaringClass());
/*  73 */       ConstructorMatcher conMatcher = new ConstructorMatcher(calledAdvisor, calledCon, null);
/*  74 */       return conMatcher.matches(astCon);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  78 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/*  84 */     WithinMatcher within = null;
/*     */     try
/*     */     {
/*  87 */       within = new WithinMatcher(this.advisor, this.call.where(), null);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  91 */       throw new RuntimeException(e);
/*     */     }
/*  93 */     return node.jjtAccept(within, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/*  98 */     WithinMatcher within = null;
/*     */     try
/*     */     {
/* 101 */       within = new WithinMatcher(this.advisor, this.call.where(), null);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 105 */       throw new RuntimeException(e);
/*     */     }
/* 107 */     return node.jjtAccept(within, null);
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*     */     try
/*     */     {
/* 114 */       return new Boolean(p.matchesCall(this.advisor, this.call));
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 118 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*     */     try
/*     */     {
/* 126 */       Node n = node.jjtGetChild(0);
/* 127 */       CtConstructor con = this.call.getConstructor();
/* 128 */       if ((n instanceof ASTMethod))
/*     */       {
/* 130 */         return new Boolean(Util.has(con.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/* 134 */       return new Boolean(Util.has(con.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/* 139 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 145 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 146 */     CtConstructor con = null;
/*     */     try
/*     */     {
/* 149 */       con = this.call.getConstructor();
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 153 */       throw new RuntimeException(e);
/*     */     }
/* 155 */     return new Boolean(Util.has(con.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.NewExprMatcher
 * JD-Core Version:    0.6.0
 */