/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static Class loadClass(String name)
/*     */   {
/*  39 */     if (System.getSecurityManager() == null)
/*     */     {
/*  41 */       return LoadClassAction.NON_PRIVILEGED.loadClass(name);
/*     */     }
/*     */ 
/*  45 */     return LoadClassAction.PRIVILEGED.loadClass(name);
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 102 */     if (System.getSecurityManager() == null) {
/* 103 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/* 105 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*     */   }
/*     */ 
/*     */   public static class GetContextClassLoaderAction
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/*  92 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*     */ 
/*     */     public ClassLoader run()
/*     */     {
/*  96 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface LoadClassAction
/*     */   {
/*  53 */     public static final LoadClassAction PRIVILEGED = new LoadClassAction()
/*     */     {
/*     */       public Class loadClass(String name)
/*     */       {
/*     */         try
/*     */         {
/*  59 */           return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(name)
/*     */           {
/*     */             public Class run() throws Exception
/*     */             {
/*  63 */               return Thread.currentThread().getContextClassLoader().loadClass(this.val$name);
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/*  69 */         throw new RuntimeException("Unable to load class " + name, e.getException());
/*     */       }
/*  53 */     };
/*     */ 
/*  74 */     public static final LoadClassAction NON_PRIVILEGED = new LoadClassAction()
/*     */     {
/*     */       public Class loadClass(String name)
/*     */       {
/*     */         try
/*     */         {
/*  80 */           return Thread.currentThread().getContextClassLoader().loadClass(name);
/*     */         }
/*     */         catch (ClassNotFoundException e) {
/*     */         }
/*  84 */         throw new RuntimeException("Unable to load class " + name, e);
/*     */       }
/*  74 */     };
/*     */ 
/*     */     public abstract Class loadClass(String paramString);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.SecurityActions
 * JD-Core Version:    0.6.0
 */