/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAllParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTAndCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstruction;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTFieldExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTGet;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTNotCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTOrCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTSet;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTSubCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ 
/*     */ public class SoftClassMatcher extends MatcherHelper
/*     */ {
/*     */   protected Advisor advisor;
/*     */   protected String classname;
/*  65 */   protected boolean match = false;
/*     */   protected Class clazz;
/*     */ 
/*     */   public SoftClassMatcher(Advisor advisor, String classname, ASTStart start)
/*     */   {
/*  70 */     super(start, advisor.getManager());
/*  71 */     this.advisor = advisor;
/*  72 */     this.classname = classname;
/*  73 */     this.start = start;
/*  74 */     this.clazz = advisor.getClazz();
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  79 */     return new Boolean(p.softMatch(this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/*  84 */     return node.getBehavior().jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/*  89 */     return matches(node.getClazz());
/*     */   }
/*     */ 
/*     */   public Boolean matches(ClassExpression expr)
/*     */   {
/*  95 */     if (expr.isAnnotation())
/*     */     {
/*  97 */       if (this.advisor == null) return Boolean.TRUE;
/*  98 */       if (this.clazz == null) return Boolean.TRUE;
/*  99 */       String sub = expr.getOriginal().substring(1);
/* 100 */       if (!this.advisor.getClassMetaData().hasTag(sub))
/*     */       {
/*     */         try
/*     */         {
/* 104 */           if (this.clazz == null) return Boolean.TRUE;
/* 105 */           if (!this.advisor.hasAnnotation(sub)) return Boolean.FALSE;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 109 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*     */     }
/* 113 */     else if (expr.isInstanceOf())
/*     */     {
/* 115 */       if (this.clazz == null) return Boolean.TRUE;
/* 116 */       if (!Util.subtypeOf(this.clazz, expr, this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 119 */     else if (expr.isTypedef())
/*     */     {
/* 121 */       if (this.clazz == null) return Boolean.TRUE;
/* 122 */       if (!Util.matchesTypedef(this.clazz, expr, this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 126 */     else if (!expr.matches(this.classname)) { return Boolean.FALSE;
/*     */     }
/* 128 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 133 */     return matches(node.getClazz());
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 138 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/* 143 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstruction node, Object data)
/*     */   {
/* 148 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTGet node, Object data)
/*     */   {
/* 153 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSet node, Object data)
/*     */   {
/* 158 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFieldExecution node, Object data)
/*     */   {
/* 163 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 168 */     ClassExpression classExpression = node.getClazz();
/* 169 */     return matchClass(classExpression);
/*     */   }
/*     */ 
/*     */   private Object matchClass(ClassExpression classExpression)
/*     */   {
/* 174 */     if (classExpression.isAnnotation())
/*     */     {
/* 176 */       String sub = classExpression.getOriginal().substring(1);
/* 177 */       if (this.advisor.getClassMetaData().hasTag(sub)) return Boolean.TRUE;
/* 178 */       return new Boolean(this.advisor.hasAnnotation(this.clazz, sub));
/*     */     }
/* 180 */     if (classExpression.isInstanceOf())
/*     */     {
/* 182 */       if (this.clazz == null) return Boolean.TRUE;
/* 183 */       if (Util.subtypeOf(this.clazz, classExpression, this.advisor)) return Boolean.TRUE;
/*     */     }
/* 185 */     else if (classExpression.isTypedef())
/*     */     {
/* 187 */       if (Util.matchesTypedef(this.clazz, classExpression, this.advisor)) return Boolean.TRUE;
/*     */     }
/*     */     else
/*     */     {
/* 191 */       return new Boolean(classExpression.matches(this.classname));
/*     */     }
/* 193 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 198 */     ClassExpression classExpression = node.getClazz();
/* 199 */     return matchClass(classExpression);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/* 205 */     ClassExpression classExpression = node.getClazz();
/* 206 */     return matchClass(classExpression);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 211 */     if (this.clazz == null) return Boolean.TRUE;
/* 212 */     Node n = node.jjtGetChild(0);
/* 213 */     if ((n instanceof ASTMethod))
/*     */     {
/* 215 */       return new Boolean(Util.has(this.clazz, (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/* 219 */     return new Boolean(Util.has(this.clazz, (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 225 */     if (this.clazz == null) return Boolean.TRUE;
/* 226 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 227 */     return new Boolean(Util.has(this.clazz, f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data)
/*     */   {
/* 234 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 239 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 244 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowExpression node, Object data)
/*     */   {
/* 249 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowBoolean node, Object data)
/*     */   {
/* 254 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNotCFlow node, Object data)
/*     */   {
/* 259 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCompositeCFlow node, Object data)
/*     */   {
/* 264 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubCFlow node, Object data)
/*     */   {
/* 269 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAndCFlow node, Object data)
/*     */   {
/* 274 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrCFlow node, Object data)
/*     */   {
/* 279 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlow node, Object data)
/*     */   {
/* 284 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 289 */     return data;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.SoftClassMatcher
 * JD-Core Version:    0.6.0
 */