/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTAllParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTAnd;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTClass;
/*     */ import org.jboss.aop.pointcut.ast.ASTComposite;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTException;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTNot;
/*     */ import org.jboss.aop.pointcut.ast.ASTOr;
/*     */ import org.jboss.aop.pointcut.ast.ASTParameter;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTSub;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ import org.jboss.aop.pointcut.ast.SimpleNode;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;
/*     */ 
/*     */ public class TypeMatcher
/*     */   implements TypeExpressionParserVisitor
/*     */ {
/*     */   protected Advisor advisor;
/*     */   protected CtClass ctClass;
/*     */   protected Class clazz;
/*     */ 
/*     */   public TypeMatcher(Advisor advisor, Class clazz)
/*     */   {
/*  61 */     this.advisor = advisor;
/*  62 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public TypeMatcher(Advisor advisor, CtClass ctClass)
/*     */   {
/*  67 */     this.advisor = advisor;
/*  68 */     this.ctClass = ctClass;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/*  73 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBoolean node, Object data)
/*     */   {
/*  78 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTComposite node, Object data)
/*     */   {
/*  83 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/*  89 */     Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
/*  90 */     boolean val = bool.booleanValue();
/*  91 */     return val ? Boolean.FALSE : Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSub node, Object data)
/*     */   {
/*  96 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/*  98 */       data = node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 100 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object left)
/*     */   {
/* 105 */     Node andChild = node.jjtGetChild(0);
/* 106 */     boolean val = ((Boolean)left).booleanValue();
/* 107 */     return new Boolean((val) && (((Boolean)andChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object left)
/*     */   {
/* 112 */     Node orChild = node.jjtGetChild(0);
/* 113 */     boolean val = ((Boolean)left).booleanValue();
/* 114 */     return new Boolean((val) || (((Boolean)orChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 126 */     Node n = node.jjtGetChild(0);
/* 127 */     if ((n instanceof ASTMethod))
/*     */     {
/* 129 */       if (this.clazz != null) return new Boolean(Util.has(this.clazz, (ASTMethod)n, this.advisor));
/* 130 */       if (this.ctClass != null) return new Boolean(Util.has(this.ctClass, (ASTMethod)n, this.advisor));
/*     */     }
/*     */     else
/*     */     {
/* 134 */       if (this.clazz != null) return new Boolean(Util.has(this.clazz, (ASTConstructor)n, this.advisor));
/* 135 */       if (this.ctClass != null) return new Boolean(Util.has(this.ctClass, (ASTConstructor)n, this.advisor));
/*     */     }
/* 137 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 142 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 143 */     if (this.clazz != null) {
/* 144 */       return new Boolean(Util.has(this.clazz, f, this.advisor));
/*     */     }
/* 146 */     return new Boolean(Util.has(this.ctClass, f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTClass node, Object data)
/*     */   {
/* 151 */     if (this.clazz != null)
/*     */     {
/* 153 */       return new Boolean(Util.matchesClassExpr(node.getClazz(), this.clazz, this.advisor));
/*     */     }
/*     */ 
/* 157 */     return new Boolean(Util.matchesClassExpr(node.getClazz(), this.ctClass, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 163 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data)
/*     */   {
/* 168 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 173 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 178 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 183 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/* 188 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTException node, Object data)
/*     */   {
/* 193 */     return Boolean.FALSE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.TypeMatcher
 * JD-Core Version:    0.6.0
 */