/*    */ package org.jboss.aop.pointcut;
/*    */ 
/*    */ import java.io.StringReader;
/*    */ import javassist.CtClass;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.pointcut.ast.ASTStart;
/*    */ import org.jboss.aop.pointcut.ast.ParseException;
/*    */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*    */ 
/*    */ public class TypedefExpression
/*    */   implements Typedef
/*    */ {
/*    */   protected String name;
/*    */   protected String expr;
/*    */   protected ASTStart ast;
/*    */ 
/*    */   public TypedefExpression(String name, String expr)
/*    */     throws ParseException
/*    */   {
/* 43 */     this.name = name;
/* 44 */     this.expr = expr;
/*    */ 
/* 46 */     this.ast = new TypeExpressionParser(new StringReader(expr)).Start();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 51 */     return this.name;
/*    */   }
/*    */ 
/*    */   public String getExpr()
/*    */   {
/* 56 */     return this.expr;
/*    */   }
/*    */ 
/*    */   public boolean matches(Advisor advisor, CtClass clazz)
/*    */   {
/* 61 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 62 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*    */   }
/*    */ 
/*    */   public boolean matches(Advisor advisor, Class clazz)
/*    */   {
/* 67 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 68 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.TypedefExpression
 * JD-Core Version:    0.6.0
 */