/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ 
/*     */ public class ASTConstructor extends SimpleNode
/*     */ {
/*     */   String classExpr;
/*     */   ClassExpression clazz;
/*     */   IdentifierExpression annotation;
/*  54 */   ArrayList attributes = new ArrayList();
/*  55 */   ArrayList parameters = new ArrayList();
/*  56 */   boolean anyParameters = false;
/*  57 */   boolean hasAnyZeroOrMoreParameters = false;
/*  58 */   ArrayList exceptions = new ArrayList();
/*     */ 
/*     */   public ASTConstructor(int id)
/*     */   {
/*  31 */     super(id);
/*     */   }
/*     */ 
/*     */   public ASTConstructor(PointcutExpressionParser p, int id)
/*     */   {
/*  36 */     super(p, id);
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(PointcutExpressionParserVisitor visitor, Object data)
/*     */   {
/*  43 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(TypeExpressionParserVisitor visitor, Object data)
/*     */   {
/*  48 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public void jjtAddChild(Node n, int i)
/*     */   {
/*  62 */     if ((n instanceof ASTAttribute)) { this.attributes.add(n);
/*  63 */     } else if ((n instanceof ASTException)) { this.exceptions.add(n);
/*  64 */     } else if ((n instanceof ASTAllParameter)) { this.anyParameters = true;
/*  65 */     } else if (((n instanceof ASTParameter)) && (!this.anyParameters))
/*     */     {
/*  67 */       this.parameters.add(0, n);
/*  68 */       if ((!this.hasAnyZeroOrMoreParameters) && (((ASTParameter)n).isAnyZeroOrMoreParameters()))
/*     */       {
/*  70 */         this.hasAnyZeroOrMoreParameters = true;
/*     */       }
/*     */     } else {
/*  73 */       super.jjtAddChild(n, i);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClassExpression(String expression) {
/*  77 */     this.classExpr = expression;
/*  78 */     this.clazz = new ClassExpression(this.classExpr);
/*     */   }
/*     */ 
/*     */   public void setNewExpression(String expr)
/*     */   {
/*  83 */     if (expr.startsWith("@")) this.annotation = new IdentifierExpression(expr);
/*     */   }
/*     */ 
/*     */   public String getClassExpr()
/*     */   {
/*  88 */     return this.classExpr;
/*     */   }
/*     */ 
/*     */   public ArrayList getAttributes()
/*     */   {
/*  93 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public ArrayList getExceptions()
/*     */   {
/*  98 */     return this.exceptions;
/*     */   }
/*     */ 
/*     */   public ArrayList getParameters()
/*     */   {
/* 103 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public boolean isAnyParameters()
/*     */   {
/* 108 */     return this.anyParameters;
/*     */   }
/*     */ 
/*     */   public boolean hasAnyZeroOrMoreParameters()
/*     */   {
/* 113 */     return this.hasAnyZeroOrMoreParameters;
/*     */   }
/*     */ 
/*     */   public ClassExpression getClazz()
/*     */   {
/* 118 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public IdentifierExpression getConstructorAnnotation()
/*     */   {
/* 127 */     return this.annotation;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.ASTConstructor
 * JD-Core Version:    0.6.0
 */