/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ 
/*     */ public class IdentifierExpression
/*     */ {
/*     */   private String original;
/*     */   private Pattern namePattern;
/*     */   private boolean isAnnotation;
/*     */   private boolean isImplements;
/*     */   private boolean isImplementing;
/*     */   private ClassExpression implementsExpr;
/*     */ 
/*     */   public IdentifierExpression(String expr)
/*     */   {
/*  46 */     this.original = expr;
/*  47 */     if (expr.startsWith("@"))
/*     */     {
/*  49 */       this.isAnnotation = true;
/*     */     }
/*  51 */     else if (expr.startsWith("$implements{"))
/*     */     {
/*  53 */       this.isImplements = true;
/*  54 */       expr = expr.substring(12, expr.length() - 1);
/*  55 */       this.implementsExpr = new ClassExpression(expr.trim());
/*     */     }
/*  57 */     else if (expr.startsWith("$implementing{"))
/*     */     {
/*  59 */       this.isImplementing = true;
/*  60 */       expr = expr.substring(14, expr.length() - 1);
/*  61 */       this.implementsExpr = new ClassExpression(expr.trim());
/*     */     }
/*     */     else
/*     */     {
/*  65 */       expr = expr.replaceAll("\\*", ".*");
/*  66 */       this.namePattern = Pattern.compile(expr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean matches(String name)
/*     */   {
/*  72 */     if (this.isAnnotation) return false;
/*  73 */     Matcher m = this.namePattern.matcher(name);
/*  74 */     return m.matches();
/*     */   }
/*     */ 
/*     */   public boolean matchesAnnotation(String annotation)
/*     */   {
/*  79 */     if (!this.isAnnotation) return false;
/*  80 */     Matcher m = this.namePattern.matcher(annotation);
/*  81 */     return m.matches();
/*     */   }
/*     */ 
/*     */   public String getOriginal()
/*     */   {
/*  86 */     return this.original;
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/*  91 */     return this.isAnnotation;
/*     */   }
/*     */ 
/*     */   public boolean isImplements()
/*     */   {
/*  96 */     return this.isImplements;
/*     */   }
/*     */ 
/*     */   public boolean isImplementing()
/*     */   {
/* 101 */     return this.isImplementing;
/*     */   }
/*     */ 
/*     */   public ClassExpression getImplementsExpression()
/*     */   {
/* 106 */     return this.implementsExpr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.IdentifierExpression
 * JD-Core Version:    0.6.0
 */