/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.StringReader;
/*     */ import java.util.ArrayList;
/*     */ 
/*     */ public class PointcutParserTester
/*     */   implements PointcutExpressionParserVisitor
/*     */ {
/*  28 */   private int indent = 0;
/*     */ 
/*     */   private String indentString()
/*     */   {
/*  32 */     StringBuffer sb = new StringBuffer();
/*  33 */     for (int i = 0; i < this.indent; i++)
/*     */     {
/*  35 */       sb.append(" ");
/*     */     }
/*  37 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/*  44 */     System.out.println(indentString() + node + ": acceptor not unimplemented in subclass?");
/*     */ 
/*  46 */     this.indent += 1;
/*  47 */     data = node.childrenAccept(this, data);
/*  48 */     this.indent -= 1;
/*  49 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/*  54 */     System.out.println(indentString() + node);
/*  55 */     this.indent += 1;
/*  56 */     data = node.childrenAccept(this, data);
/*  57 */     this.indent -= 1;
/*  58 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  63 */     System.out.println(indentString() + node);
/*  64 */     this.indent += 1;
/*  65 */     data = node.childrenAccept(this, data);
/*  66 */     this.indent -= 1;
/*  67 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/*  72 */     System.out.println(indentString() + node);
/*  73 */     this.indent += 1;
/*  74 */     data = node.childrenAccept(this, data);
/*  75 */     this.indent -= 1;
/*  76 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecutionOnly node, Object data)
/*     */   {
/*  81 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBoolean node, Object data)
/*     */   {
/*  86 */     System.out.println(indentString() + node);
/*  87 */     this.indent += 1;
/*  88 */     data = node.childrenAccept(this, data);
/*  89 */     this.indent -= 1;
/*  90 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/*  95 */     System.out.print(indentString());
/*  96 */     if (node.attributes != null)
/*     */     {
/*  98 */       for (int i = 0; i < node.attributes.size(); i++)
/*     */       {
/* 100 */         ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
/* 101 */         System.out.print(attr.attribute + " ");
/*     */       }
/*     */     }
/* 104 */     System.out.print(node.getTypeExpression() + " ");
/* 105 */     System.out.println(node.getClassExpr() + "." + node.getFieldExpr());
/* 106 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/* 111 */     System.out.print(indentString());
/* 112 */     System.out.print(node.getReturnTypeExpression() + " ");
/* 113 */     if (node.attributes != null)
/*     */     {
/* 115 */       for (int i = 0; i < node.attributes.size(); i++)
/*     */       {
/* 117 */         ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
/* 118 */         System.out.print(attr.attribute + " ");
/*     */       }
/*     */     }
/* 121 */     System.out.print(node.getClassExpr() + "." + node.getMethodExpr() + "(");
/* 122 */     if ((node.parameters != null) && (!node.isAnyParameters()))
/*     */     {
/* 124 */       for (int i = 0; i < node.parameters.size(); i++)
/*     */       {
/* 126 */         if (i > 0) System.out.print(", ");
/* 127 */         System.out.print(node.parameters.get(i));
/*     */       }
/*     */     }
/* 130 */     else if (node.isAnyParameters())
/*     */     {
/* 132 */       System.out.print("..");
/*     */     }
/* 134 */     System.out.println(")");
/* 135 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 140 */     System.out.print(indentString());
/* 141 */     if (node.attributes != null)
/*     */     {
/* 143 */       for (int i = 0; i < node.attributes.size(); i++)
/*     */       {
/* 145 */         ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
/* 146 */         System.out.print(attr.attribute + " ");
/*     */       }
/*     */     }
/* 149 */     System.out.print(node.getClassExpr() + "(");
/* 150 */     if ((node.parameters != null) && (!node.isAnyParameters()))
/*     */     {
/* 152 */       for (int i = 0; i < node.parameters.size(); i++)
/*     */       {
/* 154 */         if (i > 0) System.out.print(", ");
/* 155 */         System.out.print(node.parameters.get(i));
/*     */       }
/*     */     }
/* 158 */     else if (node.isAnyParameters())
/*     */     {
/* 160 */       System.out.print("..");
/*     */     }
/*     */ 
/* 163 */     System.out.println(")");
/* 164 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 169 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTComposite node, Object data)
/*     */   {
/* 174 */     System.out.println(indentString() + node);
/* 175 */     this.indent += 1;
/* 176 */     data = node.childrenAccept(this, data);
/* 177 */     this.indent -= 1;
/* 178 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowExpression node, Object data)
/*     */   {
/* 183 */     System.out.println(indentString() + node);
/* 184 */     this.indent += 1;
/* 185 */     data = node.childrenAccept(this, data);
/* 186 */     this.indent -= 1;
/* 187 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlow node, Object data) {
/* 191 */     System.out.println(indentString() + node);
/* 192 */     this.indent += 1;
/* 193 */     data = node.childrenAccept(this, data);
/* 194 */     this.indent -= 1;
/* 195 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSub node, Object data)
/*     */   {
/* 200 */     System.out.println(indentString() + node);
/* 201 */     this.indent += 1;
/* 202 */     data = node.childrenAccept(this, data);
/* 203 */     this.indent -= 1;
/* 204 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object data)
/*     */   {
/* 209 */     System.out.println(indentString() + node);
/* 210 */     this.indent += 1;
/* 211 */     data = node.childrenAccept(this, data);
/* 212 */     this.indent -= 1;
/* 213 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object data)
/*     */   {
/* 218 */     System.out.println(indentString() + node);
/* 219 */     this.indent += 1;
/* 220 */     data = node.childrenAccept(this, data);
/* 221 */     this.indent -= 1;
/* 222 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/* 227 */     System.out.println(indentString() + node);
/* 228 */     this.indent += 1;
/* 229 */     data = node.childrenAccept(this, data);
/* 230 */     this.indent -= 1;
/* 231 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNotCFlow node, Object data)
/*     */   {
/* 236 */     System.out.println(indentString() + node);
/* 237 */     this.indent += 1;
/* 238 */     data = node.childrenAccept(this, data);
/* 239 */     this.indent -= 1;
/* 240 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowBoolean node, Object data)
/*     */   {
/* 245 */     System.out.println(indentString() + node);
/* 246 */     this.indent += 1;
/* 247 */     data = node.childrenAccept(this, data);
/* 248 */     this.indent -= 1;
/* 249 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCompositeCFlow node, Object data)
/*     */   {
/* 254 */     System.out.println(indentString() + node);
/* 255 */     this.indent += 1;
/* 256 */     data = node.childrenAccept(this, data);
/* 257 */     this.indent -= 1;
/* 258 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrCFlow node, Object data)
/*     */   {
/* 263 */     System.out.println(indentString() + node);
/* 264 */     this.indent += 1;
/* 265 */     data = node.childrenAccept(this, data);
/* 266 */     this.indent -= 1;
/* 267 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAndCFlow node, Object data)
/*     */   {
/* 272 */     System.out.println(indentString() + node);
/* 273 */     this.indent += 1;
/* 274 */     data = node.childrenAccept(this, data);
/* 275 */     this.indent -= 1;
/* 276 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubCFlow node, Object data)
/*     */   {
/* 281 */     System.out.println(indentString() + node);
/* 282 */     this.indent += 1;
/* 283 */     data = node.childrenAccept(this, data);
/* 284 */     this.indent -= 1;
/* 285 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 290 */     System.out.println(indentString() + node);
/* 291 */     this.indent += 1;
/* 292 */     System.out.println(indentString() + node.getClasseExpression());
/* 293 */     this.indent -= 1;
/* 294 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFieldExecution node, Object data)
/*     */   {
/* 299 */     System.out.println(indentString() + node);
/* 300 */     this.indent += 1;
/* 301 */     data = node.childrenAccept(this, data);
/* 302 */     this.indent -= 1;
/* 303 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/* 308 */     System.out.println(indentString() + node);
/* 309 */     this.indent += 1;
/* 310 */     data = node.getBehavior().jjtAccept(this, data);
/* 311 */     this.indent -= 1;
/* 312 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/* 317 */     System.out.println(indentString() + node);
/* 318 */     this.indent += 1;
/* 319 */     data = node.childrenAccept(this, data);
/* 320 */     this.indent -= 1;
/* 321 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstruction node, Object data)
/*     */   {
/* 326 */     System.out.println(indentString() + node);
/* 327 */     this.indent += 1;
/* 328 */     data = node.childrenAccept(this, data);
/* 329 */     this.indent -= 1;
/* 330 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTGet node, Object data)
/*     */   {
/* 335 */     System.out.println(indentString() + node);
/* 336 */     this.indent += 1;
/* 337 */     data = node.childrenAccept(this, data);
/* 338 */     this.indent -= 1;
/* 339 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSet node, Object data)
/*     */   {
/* 344 */     System.out.println(indentString() + node);
/* 345 */     this.indent += 1;
/* 346 */     data = node.childrenAccept(this, data);
/* 347 */     this.indent -= 1;
/* 348 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTPointcut node, Object data)
/*     */   {
/* 353 */     System.out.println(indentString() + node);
/* 354 */     this.indent += 1;
/* 355 */     data = node.childrenAccept(this, data);
/* 356 */     this.indent -= 1;
/* 357 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 362 */     System.out.println(indentString() + node);
/* 363 */     this.indent += 1;
/* 364 */     data = node.childrenAccept(this, data);
/* 365 */     this.indent -= 1;
/* 366 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 371 */     System.out.println(indentString() + node);
/* 372 */     this.indent += 1;
/* 373 */     data = node.childrenAccept(this, data);
/* 374 */     this.indent -= 1;
/* 375 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAttribute node, Object data) {
/* 379 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTException node, Object data)
/*     */   {
/* 384 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAllParameter node, Object data)
/*     */   {
/* 389 */     return null;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 394 */     args = new String[1];
/* 395 */     args[0] = "execution(* $instanceof{com.blah.Test}->$implements{@IF}(..) throws Exception)";
/* 396 */     System.out.println("----" + args[0]);
/* 397 */     StringReader reader = new StringReader(args[0]);
/* 398 */     PointcutExpressionParser t = new PointcutExpressionParser(reader);
/*     */     try
/*     */     {
/* 403 */       ASTStart n = t.Start();
/* 404 */       PointcutExpressionParserVisitor v = new PointcutParserTester();
/* 405 */       n.jjtAccept(v, null);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 409 */       System.out.println("Oops.");
/* 410 */       System.out.println(e.getMessage());
/* 411 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.PointcutParserTester
 * JD-Core Version:    0.6.0
 */