/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassContainer;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.util.ConstructorComparator;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class ClassProxyContainer extends ClassContainer
/*     */ {
/*     */   public ClassProxyContainer(String name, AspectManager manager)
/*     */   {
/*  54 */     super(name, manager);
/*     */   }
/*     */ 
/*     */   protected void createConstructorTables()
/*     */   {
/*  59 */     Class useClass = this.clazz;
/*  60 */     if ((this.clazz.getName().startsWith("AOPContainerProxy$")) && (this.clazz != null) && (this.clazz.getSuperclass() != null))
/*     */     {
/*  62 */       useClass = this.clazz.getSuperclass();
/*     */     }
/*  64 */     if (useClass != null)
/*     */     {
/*  66 */       Class theUseClass = useClass;
/*  67 */       AccessController.doPrivileged(new PrivilegedAction(theUseClass)
/*     */       {
/*     */         public Object run()
/*     */         {
/*  71 */           ClassProxyContainer.access$002(ClassProxyContainer.this, this.val$theUseClass.getDeclaredConstructors());
/*  72 */           for (int i = 0; i < ClassProxyContainer.this.constructors.length; i++)
/*     */           {
/*  74 */             ClassProxyContainer.this.constructors[i].setAccessible(true);
/*     */           }
/*  76 */           return null;
/*     */         }
/*     */       });
/*  79 */       Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createMethodMap()
/*     */   {
/*  86 */     initAdvisedMethodsMap();
/*     */     try
/*     */     {
/*  89 */       Method[] declaredMethods = this.clazz.getMethods();
/*     */ 
/*  91 */       Class superclass = this.clazz.getSuperclass();
/*  92 */       for (int i = 0; i < declaredMethods.length; i++)
/*     */       {
/*  94 */         Method method = declaredMethods[i];
/*  95 */         if (!ClassAdvisor.isAdvisable(method))
/*     */           continue;
/*  97 */         long hash = MethodHashing.methodHash(method);
/*     */         try
/*     */         {
/* 100 */           if ((method.getDeclaringClass().getName().indexOf("AOPContainerProxy$") >= 0) && (superclass != null)) {
/* 101 */             method = superclass.getMethod(method.getName(), method.getParameterTypes());
/*     */           }
/*     */         }
/*     */         catch (NoSuchMethodException ignored)
/*     */         {
/*     */         }
/* 107 */         this.advisedMethods.put(hash, method);
/*     */       }
/*     */       Iterator it;
/* 111 */       for (int i = 0; i < this.interfaceIntroductions.size(); i++)
/*     */       {
/* 113 */         InterfaceIntroduction ii = (InterfaceIntroduction)this.interfaceIntroductions.get(i);
/* 114 */         String[] intf = ii.getInterfaces();
/* 115 */         addMethodsFromInterfaces(intf);
/*     */ 
/* 117 */         ArrayList mixins = ii.getMixins();
/* 118 */         if (mixins.size() <= 0)
/*     */           continue;
/* 120 */         for (it = mixins.iterator(); it.hasNext(); )
/*     */         {
/* 122 */           InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)it.next();
/* 123 */           String[] mintf = mixin.getInterfaces();
/* 124 */           addMethodsFromInterfaces(mintf);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 131 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addMethodsFromInterfaces(String[] intf) throws Exception
/*     */   {
/* 137 */     ClassLoader cl = SecurityActions.getContextClassLoader();
/* 138 */     for (int j = 0; (intf != null) && (j < intf.length); j++)
/*     */     {
/* 141 */       Class iface = cl.loadClass(intf[j]);
/* 142 */       Method[] ifaceMethods = iface.getMethods();
/* 143 */       for (int k = 0; k < ifaceMethods.length; k++)
/*     */       {
/* 145 */         long hash = MethodHashing.methodHash(ifaceMethods[k]);
/*     */ 
/* 147 */         if (this.advisedMethods.get(hash) != null)
/*     */           continue;
/* 149 */         this.advisedMethods.put(hash, ifaceMethods[k]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public InstanceProxyContainer createInstanceProxyContainer()
/*     */   {
/* 158 */     ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, null, this.clazz, false);
/* 159 */     domain.setInheritsBindings(true);
/* 160 */     domain.setInheritsDeclarations(true);
/*     */ 
/* 162 */     InstanceProxyContainer ia = new InstanceProxyContainer(super.getName(), domain, this, null);
/*     */ 
/* 164 */     return ia;
/*     */   }
/*     */ 
/*     */   public void initialise(Class proxiedClass)
/*     */   {
/* 169 */     setClass(proxiedClass);
/* 170 */     ((ProxyAdvisorDomain)this.manager).attachAdvisor();
/* 171 */     initializeInterfaceIntroductions(proxiedClass);
/* 172 */     super.initializeClassContainer();
/*     */   }
/*     */ 
/*     */   protected Advisor getParentAdvisor()
/*     */   {
/* 177 */     return null;
/*     */   }
/*     */ 
/*     */   public void addPerClassAspect(AspectDefinition def)
/*     */   {
/* 182 */     Advisor parentAdvisor = getParentAdvisor();
/* 183 */     if (parentAdvisor != null)
/*     */     {
/* 185 */       parentAdvisor.addPerClassAspect(def);
/* 186 */       return;
/*     */     }
/* 188 */     super.addPerClassAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerClassAspect(AspectDefinition def)
/*     */   {
/* 197 */     Advisor parentAdvisor = getParentAdvisor();
/*     */ 
/* 199 */     if (parentAdvisor != null)
/*     */     {
/* 201 */       Object aspect = parentAdvisor.getPerClassAspect(def);
/* 202 */       if (aspect != null) return aspect;
/*     */     }
/*     */ 
/* 205 */     return super.getPerClassAspect(def);
/*     */   }
/*     */ 
/*     */   public boolean chainOverridingForInheritedMethods()
/*     */   {
/* 215 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.ClassProxyContainer
 * JD-Core Version:    0.6.0
 */