/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Domain;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public class ContainerCache
/*     */ {
/*     */   private static volatile int counter;
/*  43 */   public static final Object mapLock = new Object();
/*  44 */   private static WeakHashMap containerCache = new WeakHashMap();
/*     */   private AspectManager manager;
/*     */   private ContainerProxyCacheKey key;
/*     */   private Advisor classAdvisor;
/*     */   private InstanceProxyContainer instanceContainer;
/*     */   boolean isClassProxyContainer;
/*     */   Class[] interfaces;
/*     */   AOPProxyFactoryMixin[] mixins;
/*     */   MetaData metaData;
/*     */   boolean metaDataHasInstanceLevelData;
/*     */   SimpleMetaData simpleMetaData;
/*     */ 
/*     */   private ContainerCache(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaData metaData, boolean metaDataHasInstanceLevelData, SimpleMetaData simpleMetaData)
/*     */   {
/*  61 */     this.manager = manager;
/*  62 */     this.interfaces = interfaces;
/*  63 */     this.mixins = mixins;
/*  64 */     this.metaData = metaData;
/*  65 */     this.simpleMetaData = simpleMetaData;
/*  66 */     this.metaDataHasInstanceLevelData = metaDataHasInstanceLevelData;
/*  67 */     this.key = new ContainerProxyCacheKey(manager.getManagerFQN(), proxiedClass, interfaces, mixins, metaData);
/*     */   }
/*     */ 
/*     */   public static ContainerCache initialise(AspectManager manager, Class proxiedClass, MetaData metaData, boolean metaDataHasInstanceLevelData)
/*     */   {
/*  72 */     return initialise(manager, proxiedClass, null, null, metaData, metaDataHasInstanceLevelData, null);
/*     */   }
/*     */ 
/*     */   public static ContainerCache initialise(AspectManager manager, AOPProxyFactoryParameters params)
/*     */   {
/*  77 */     return initialise(manager, params.getProxiedClass(), params.getInterfaces(), params.getMixins(), params.getMetaData(), params.getMetaDataHasInstanceLevelData(), params.getSimpleMetaData());
/*     */   }
/*     */ 
/*     */   private static ContainerCache initialise(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaData metaData, boolean metaDataHasInstanceLevelData, SimpleMetaData simpleMetaData)
/*     */   {
/*  89 */     ContainerCache factory = new ContainerCache(manager, proxiedClass, interfaces, mixins, metaData, metaDataHasInstanceLevelData, simpleMetaData);
/*  90 */     synchronized (mapLock)
/*     */     {
/*  92 */       factory.initClassContainer();
/*  93 */       factory.initInstanceContainer();
/*     */     }
/*     */ 
/*  96 */     return factory;
/*     */   }
/*     */ 
/*     */   public ContainerProxyCacheKey getKey()
/*     */   {
/* 101 */     return this.key;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/* 106 */     return this.instanceContainer != null ? this.instanceContainer : this.classAdvisor;
/*     */   }
/*     */ 
/*     */   public Advisor getClassAdvisor()
/*     */   {
/* 111 */     return this.classAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceProxyContainer getInstanceContainer()
/*     */   {
/* 116 */     return this.instanceContainer;
/*     */   }
/*     */ 
/*     */   public boolean hasAspects()
/*     */   {
/* 121 */     if (this.instanceContainer != null)
/*     */     {
/* 123 */       return this.instanceContainer.hasAspects();
/*     */     }
/* 125 */     return this.classAdvisor.hasAspects();
/*     */   }
/*     */ 
/*     */   public boolean requiresInstanceAdvisor()
/*     */   {
/* 130 */     return (hasInterfaceIntroductions()) || (hasMixins()) || ((this.metaData != null) && (this.metaDataHasInstanceLevelData)) || (this.simpleMetaData != null);
/*     */   }
/*     */ 
/*     */   public boolean isAdvised()
/*     */   {
/* 135 */     return Advised.class.isAssignableFrom(this.key.getClazz());
/*     */   }
/*     */ 
/*     */   private boolean hasInterfaceIntroductions()
/*     */   {
/* 140 */     return (this.interfaces != null) && (this.interfaces.length > 0);
/*     */   }
/*     */ 
/*     */   private boolean hasMixins()
/*     */   {
/* 145 */     return (this.mixins != null) && (this.mixins.length > 0);
/*     */   }
/*     */ 
/*     */   private void initClassContainer()
/*     */   {
/* 150 */     if (Advised.class.isAssignableFrom(this.key.getClazz()))
/*     */     {
/* 152 */       this.classAdvisor = AspectManager.instance().getAdvisor(this.key.getClazz());
/*     */     }
/*     */     else
/*     */     {
/* 156 */       this.classAdvisor = getCachedContainer(this.manager);
/* 157 */       if (this.classAdvisor == null)
/*     */       {
/* 159 */         this.classAdvisor = createAndCacheContainer();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ClassProxyContainer getCachedContainer(AspectManager manager)
/*     */   {
/* 166 */     HashMap managerContainers = (HashMap)containerCache.get(this.key.getClazz());
/* 167 */     if (managerContainers != null)
/*     */     {
/* 169 */       return (ClassProxyContainer)managerContainers.get(manager.getManagerFQN());
/*     */     }
/* 171 */     return null;
/*     */   }
/*     */ 
/*     */   private ClassProxyContainer createAndCacheContainer()
/*     */   {
/* 176 */     ClassProxyContainer container = createContainer();
/* 177 */     cacheContainer(this.key, container);
/* 178 */     return container;
/*     */   }
/*     */ 
/*     */   private ClassProxyContainer createContainer()
/*     */   {
/* 183 */     String name = Domain.getDomainName(this.key.getClazz(), false);
/* 184 */     ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, name, this.key.getClazz(), false);
/* 185 */     String classname = this.key.getClazz() != null ? this.key.getClazz().getName() : "AOP$Hollow";
/* 186 */     ClassProxyContainer container = new ClassProxyContainer(classname, domain);
/* 187 */     domain.setAdvisor(container);
/* 188 */     container.initialise(this.key.getClazz());
/*     */ 
/* 190 */     return container;
/*     */   }
/*     */ 
/*     */   private void cacheContainer(ContainerProxyCacheKey key, ClassProxyContainer container)
/*     */   {
/* 195 */     HashMap managerContainers = (HashMap)containerCache.get(key.getClazz());
/* 196 */     if (managerContainers == null)
/*     */     {
/* 198 */       managerContainers = new HashMap();
/* 199 */       containerCache.put(key.getClazz(), managerContainers);
/*     */     }
/* 201 */     managerContainers.put(key.getManagerFQN(), container);
/*     */   }
/*     */ 
/*     */   private InterfaceIntroduction getInterfaceIntroduction()
/*     */   {
/* 206 */     int introductionLength = hasInterfaceIntroductions() ? this.interfaces.length : 0;
/* 207 */     int mixinLength = hasMixins() ? this.mixins.length : 0;
/*     */ 
/* 209 */     if ((introductionLength == 0) && (mixinLength == 0))
/*     */     {
/* 211 */       return null;
/*     */     }
/*     */ 
/* 214 */     Class proxiedClass = this.classAdvisor.getClazz();
/* 215 */     if (proxiedClass == null)
/*     */     {
/* 217 */       proxiedClass = Object.class;
/*     */     }
/* 219 */     String[] introducedNames = getClassNames(this.interfaces);
/* 220 */     InterfaceIntroduction intro = new InterfaceIntroduction("Introduction" + counter++, proxiedClass.getName(), introducedNames);
/*     */ 
/* 222 */     if (mixinLength > 0)
/*     */     {
/* 224 */       addMixins(intro);
/*     */     }
/*     */ 
/* 227 */     return intro;
/*     */   }
/*     */ 
/*     */   private void addMixins(InterfaceIntroduction intro)
/*     */   {
/* 232 */     for (int i = 0; (i < this.mixins.length) && (this.mixins != null); i++)
/*     */     {
/* 234 */       Class[] mixinInterfaces = this.mixins[i].getInterfaces();
/* 235 */       Class mixinClass = this.mixins[i].getMixin();
/*     */ 
/* 237 */       if (mixinInterfaces == null)
/*     */       {
/* 239 */         throw new RuntimeException("When defining a mixin, interfaces must be defined");
/*     */       }
/* 241 */       if (mixinClass == null)
/*     */       {
/* 243 */         throw new RuntimeException("When defining a mixin, the mixin must be defined");
/*     */       }
/*     */ 
/* 246 */       String[] mixinInterfaceNames = getClassNames(mixinInterfaces);
/* 247 */       InterfaceIntroduction.Mixin mixin = new InterfaceIntroduction.Mixin(mixinClass.getName(), mixinInterfaceNames, this.mixins[i].getConstruction(), false);
/* 248 */       intro.addMixin(mixin);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String[] getClassNames(Class[] classes)
/*     */   {
/* 254 */     if (classes == null)
/*     */     {
/* 256 */       return null;
/*     */     }
/*     */ 
/* 259 */     String[] names = new String[classes.length];
/* 260 */     for (int i = 0; i < classes.length; i++)
/*     */     {
/* 262 */       names[i] = classes[i].getName();
/*     */     }
/* 264 */     return names;
/*     */   }
/*     */ 
/*     */   private void initInstanceContainer()
/*     */   {
/* 269 */     if (requiresInstanceAdvisor())
/*     */     {
/* 271 */       InterfaceIntroduction introduction = null;
/* 272 */       if ((hasInterfaceIntroductions()) || (hasMixins()))
/*     */       {
/* 274 */         introduction = getInterfaceIntroduction();
/*     */       }
/*     */ 
/* 277 */       this.instanceContainer = InstanceProxyContainer.createInstanceProxyContainer(this.classAdvisor, introduction, this.metaData);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.ContainerCache
 * JD-Core Version:    0.6.0
 */