/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GeneratedAOPProxyFactory
/*     */   implements AOPProxyFactory
/*     */ {
/*  39 */   private static final Logger logger = AOPLogger.getLogger(GeneratedAOPProxyFactory.class);
/*     */ 
/*     */   public static <T> T createProxy(T target, Class<T> interfaceClass)
/*     */   {
/*  50 */     if (target == null) {
/*  51 */       return null;
/*     */     }
/*  53 */     GeneratedAOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
/*  54 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/*  55 */     params.setInterfaces(new Class[] { interfaceClass });
/*  56 */     params.setObjectAsSuperClass(true);
/*  57 */     params.setTarget(target);
/*  58 */     Object proxy = proxyFactory.createAdvisedProxy(params);
/*  59 */     if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*  60 */       logger.debug("Created proxy: " + proxy.getClass() + "@" + System.identityHashCode(proxy) + " target: " + target.getClass());
/*  61 */     return interfaceClass.cast(proxy);
/*     */   }
/*     */ 
/*     */   public Object createAdvisedProxy(AOPProxyFactoryParameters params)
/*     */   {
/*  66 */     if (params.getTarget() != null)
/*     */     {
/*  68 */       if (params.getProxiedClass() != null)
/*     */       {
/*  70 */         if (!params.getProxiedClass().isAssignableFrom(params.getTarget().getClass()))
/*     */         {
/*  72 */           throw new RuntimeException("Specified class type " + params.getProxiedClass().getName() + " and target " + params.getTarget().getClass().getName() + " are not compatible");
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*  77 */         params.setProxiedClass(params.getTarget().getClass());
/*     */       }
/*     */     }
/*  80 */     else if (params.getProxiedClass() == null)
/*     */     {
/*  82 */       params.setProxiedClass(Object.class);
/*     */     }
/*     */ 
/*  85 */     return getProxy(params);
/*     */   }
/*     */ 
/*     */   private Object getProxy(AOPProxyFactoryParameters params)
/*     */   {
/*     */     try
/*     */     {
/*  92 */       Class proxyClass = null;
/*     */ 
/*  94 */       boolean isAdvised = Advised.class.isAssignableFrom(params.getProxiedClass());
/*     */ 
/*  96 */       if (((params.getTarget() instanceof Untransformable)) || ((isAdvised) && (params.getInterfaces() == null) && (params.getMixins() == null) && ((params.getMetaData() == null) || (!params.getMetaDataHasInstanceLevelData())) && (params.getSimpleMetaData() == null)))
/*     */       {
/*  98 */         return params.getTarget();
/*     */       }
/*     */ 
/* 102 */       synchronized (ContainerCache.mapLock)
/*     */       {
/* 104 */         if (params.getContainerCache() == null)
/*     */         {
/* 106 */           params.setContainerCache(ContainerCache.initialise(AspectManager.instance(), params));
/*     */         }
/*     */ 
/* 110 */         if ((!params.getContainerCache().hasAspects()) && (!params.getContainerCache().requiresInstanceAdvisor()))
/*     */         {
/* 112 */           return params.getTarget();
/*     */         }
/*     */ 
/* 116 */         proxyClass = generateProxy(params);
/*     */       }
/*     */ 
/* 120 */       return instantiateAndConfigureProxy(proxyClass, params);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 124 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private Class generateProxy(AOPProxyFactoryParameters params)
/*     */     throws Exception
/*     */   {
/* 130 */     Class proxyClass = ContainerProxyFactory.getProxyClass(params.isObjectAsSuperClass(), params.getContainerCache().getKey(), params.getContainerCache().getAdvisor());
/*     */ 
/* 132 */     return proxyClass;
/*     */   }
/*     */ 
/*     */   private Object instantiateAndConfigureProxy(Class proxyClass, AOPProxyFactoryParameters params)
/*     */     throws Exception
/*     */   {
/*     */     AspectManaged proxy;
/*     */     AspectManaged proxy;
/* 139 */     if (params.getCtor() != null)
/*     */     {
/* 141 */       Constructor ctor = proxyClass.getConstructor(params.getCtor().getSignature());
/* 142 */       proxy = (AspectManaged)ctor.newInstance(params.getCtor().getArguments());
/*     */     }
/*     */     else
/*     */     {
/* 146 */       proxy = (AspectManaged)proxyClass.newInstance();
/*     */     }
/*     */ 
/* 149 */     proxy.setAdvisor(params.getContainerCache().getClassAdvisor());
/*     */ 
/* 151 */     if (params.getContainerCache().getInstanceContainer() != null)
/*     */     {
/* 153 */       proxy.setInstanceAdvisor(params.getContainerCache().getInstanceContainer());
/*     */     }
/*     */ 
/* 156 */     if (params.getSimpleMetaData() != null)
/*     */     {
/* 158 */       proxy.setMetadata(params.getSimpleMetaData());
/*     */     }
/*     */ 
/* 161 */     if (params.getTarget() != null)
/*     */     {
/* 163 */       ((Delegate)proxy).setDelegate(params.getTarget());
/*     */     }
/*     */     else
/*     */     {
/* 167 */       ((Delegate)proxy).setDelegate(new Object());
/*     */     }
/*     */ 
/* 170 */     return proxy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.GeneratedAOPProxyFactory
 * JD-Core Version:    0.6.0
 */