/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ProxyTemplate
/*     */   implements Delegate, AspectManaged
/*     */ {
/*     */   private transient Advisor classAdvisor;
/*     */   private transient InstanceAdvisor instanceAdvisor;
/*     */   protected volatile transient Advisor currentAdvisor;
/*     */   private Object delegate;
/*     */   private Object[] mixins;
/*     */   private SimpleMetaData metadata;
/*     */ 
/*     */   public Object getDelegate()
/*     */   {
/*  53 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public void setDelegate(Object delegate)
/*     */   {
/*  58 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/*  63 */     return this.currentAdvisor;
/*     */   }
/*     */ 
/*     */   public void setAdvisor(Advisor advisor)
/*     */   {
/*  68 */     this.classAdvisor = advisor;
/*  69 */     this.currentAdvisor = this.classAdvisor;
/*     */   }
/*     */ 
/*     */   public void setMetadata(SimpleMetaData metadata)
/*     */   {
/*  74 */     this.metadata = metadata;
/*     */   }
/*     */ 
/*     */   public void setInstanceAdvisor(InstanceAdvisor ia)
/*     */   {
/*  79 */     synchronized (this)
/*     */     {
/*  81 */       if (this.instanceAdvisor != null)
/*     */       {
/*  83 */         throw new RuntimeException("InstanceAdvisor already set");
/*     */       }
/*     */ 
/*  86 */       if (!(ia instanceof InstanceProxyContainer))
/*     */       {
/*  88 */         throw new RuntimeException("Wrong type for instance advisor: " + this.instanceAdvisor);
/*     */       }
/*  90 */       this.instanceAdvisor = ia;
/*     */ 
/*  92 */       this.currentAdvisor = ((InstanceProxyContainer)ia);
/*     */     }
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor getInstanceAdvisor()
/*     */   {
/*  98 */     synchronized (this)
/*     */     {
/* 100 */       if (this.instanceAdvisor == null)
/*     */       {
/* 102 */         InstanceProxyContainer ipc = ((ClassProxyContainer)this.currentAdvisor).createInstanceProxyContainer();
/* 103 */         setInstanceAdvisor(ipc);
/*     */       }
/*     */     }
/* 106 */     return this.instanceAdvisor;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 111 */     if (this.delegate != null)
/*     */     {
/* 113 */       if ((obj != null) && ((obj instanceof AspectManaged)))
/* 114 */         obj = ((AspectManaged)obj).getDelegate();
/* 115 */       return this.delegate.equals(obj);
/*     */     }
/*     */ 
/* 118 */     return super.equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 123 */     if (this.delegate != null) {
/* 124 */       return this.delegate.hashCode();
/*     */     }
/* 126 */     return super.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 131 */     if (this.delegate != null) {
/* 132 */       return this.delegate.toString() + " (proxied by " + getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ")";
/*     */     }
/* 134 */     return super.toString() + "(empty proxy of " + getClass().getSuperclass().getName() + ")";
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 147 */     out.writeObject(this.delegate);
/* 148 */     out.writeObject(this.mixins);
/* 149 */     out.writeObject(this.metadata);
/* 150 */     out.writeObject(this.classAdvisor.getClazz());
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 156 */     this.delegate = in.readObject();
/* 157 */     this.mixins = ((Object[])(Object[])in.readObject());
/* 158 */     this.metadata = ((SimpleMetaData)in.readObject());
/*     */ 
/* 160 */     Class clazz = (Class)in.readObject();
/* 161 */     AspectManager manager = AspectManager.getTopLevelAspectManager();
/* 162 */     this.classAdvisor = manager.findAdvisor(clazz);
/* 163 */     this.currentAdvisor = this.classAdvisor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.ProxyTemplate
 * JD-Core Version:    0.6.0
 */