/*     */ package org.jboss.aop.standalone;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileReader;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Field;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.net.URLDecoder;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.instrument.TransformationException;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Compiler
/*     */ {
/*  57 */   private static final Logger logger = AOPLogger.getLogger(Compiler.class);
/*     */   private FileFilter classFileFilter;
/*     */   private FileFilter directoryFilter;
/*     */   public boolean verbose;
/*     */   public boolean suppress;
/*     */   public boolean optimized;
/*     */   public static URLClassLoader loader;
/*     */   private HashMap classesToCompile;
/*     */ 
/*     */   public Compiler()
/*     */   {
/*  58 */     this.classFileFilter = new FileFilter()
/*     */     {
/*     */       public boolean accept(File pathname)
/*     */       {
/*  62 */         return pathname.getName().endsWith(".class");
/*     */       }
/*     */     };
/*  66 */     this.directoryFilter = new FileFilter()
/*     */     {
/*     */       public boolean accept(File pathname)
/*     */       {
/*  70 */         return pathname.isDirectory();
/*     */       }
/*     */     };
/*  74 */     this.verbose = false;
/*  75 */     this.suppress = true;
/*  76 */     this.optimized = true;
/*     */ 
/* 241 */     this.classesToCompile = new HashMap();
/*     */   }
/*     */ 
/*     */   public boolean isJarFile(File src)
/*     */   {
/*  80 */     return (src.isFile()) && ((src.getName().toLowerCase().endsWith(".jar")) || (src.getName().toLowerCase().endsWith(".zip")));
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  88 */     long start = System.currentTimeMillis();
/*  89 */     Compiler c = new Compiler();
/*     */     try
/*     */     {
/*  92 */       c.compile(args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  96 */       if (c.verbose) throw e;
/*     */ 
/*  98 */       if ((e instanceof TransformationException))
/*     */       {
/* 100 */         System.exit(1);
/*     */       }
/* 102 */       throw e;
/*     */     }
/* 104 */     System.out.println("Build Successful: " + (System.currentTimeMillis() - start) + " ms");
/*     */   }
/*     */ 
/*     */   public void usage()
/*     */   {
/* 109 */     System.err.println("Usage: aopc [-cp <classpath>] [-classpath <classpath>] [-report] [-noopt] [-verbose] [-aoppath <xml files>] <dir>+");
/*     */   }
/*     */ 
/*     */   public void compile(String[] args)
/*     */     throws Exception
/*     */   {
/* 120 */     if (args.length == 0)
/*     */     {
/* 122 */       usage();
/* 123 */       System.exit(1);
/* 124 */       return;
/*     */     }
/* 126 */     ArrayList paths = new ArrayList();
/* 127 */     ArrayList files = new ArrayList();
/* 128 */     boolean report = false;
/* 129 */     for (int i = 0; i < args.length; i++)
/*     */     {
/* 131 */       if (args[i].equals("-verbose"))
/*     */       {
/* 133 */         this.verbose = true;
/*     */       }
/* 136 */       else if (args[i].equals("-suppress"))
/*     */       {
/* 138 */         this.suppress = true;
/*     */       }
/* 141 */       else if (args[i].equals("-noopt"))
/*     */       {
/* 143 */         this.optimized = false;
/*     */       }
/* 146 */       else if (args[i].equals("-report"))
/*     */       {
/* 148 */         report = true;
/*     */       }
/*     */       else
/*     */       {
/*     */         StringTokenizer tokenizer;
/* 151 */         if ((args[i].equals("-cp")) || (args[i].equals("-classpath")))
/*     */         {
/* 153 */           if (i + 1 > args.length - 1)
/*     */           {
/* 155 */             usage();
/* 156 */             System.exit(1);
/* 157 */             return;
/*     */           }
/* 159 */           i++;
/* 160 */           tokenizer = new StringTokenizer(args[i], File.pathSeparator);
/* 161 */         }while (tokenizer.hasMoreTokens())
/*     */         {
/* 163 */           String cpath = tokenizer.nextToken();
/* 164 */           File f = new File(cpath);
/* 165 */           paths.add(f.toURL());
/* 166 */           continue;
/*     */ 
/* 169 */           if (args[i].equals("-aoppath"))
/*     */           {
/* 171 */             i++; System.setProperty("jboss.aop.path", args[i]);
/*     */           }
/* 174 */           else if (args[i].equals("-aopclasspath"))
/*     */           {
/* 176 */             i++; System.setProperty("jboss.aop.class.path", args[i]);
/*     */           }
/* 179 */           else if (args[i].equals("--SOURCEPATH"))
/*     */           {
/* 181 */             i++; addFilesFromSourcePathFile(files, args[i]);
/*     */           }
/*     */           else {
/* 184 */             File f = new File(args[i]).getCanonicalFile();
/* 185 */             files.add(f);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 189 */     URL[] urls = (URL[])(URL[])paths.toArray(new URL[paths.size()]);
/* 190 */     loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
/*     */ 
/* 192 */     Thread.currentThread().setContextClassLoader(loader);
/*     */ 
/* 194 */     org.jboss.aop.Deployment.searchClasspath = true;
/* 195 */     AspectManager.verbose = this.verbose;
/* 196 */     AspectManager.suppressReferenceErrors = this.suppress;
/* 197 */     AspectManager.optimize = this.optimized;
/* 198 */     AspectManager.instance();
/*     */     Iterator it;
/* 200 */     if (report)
/*     */     {
/* 202 */       for (int i = 0; i < files.size(); i++)
/*     */       {
/* 204 */         File f = (File)files.get(i);
/* 205 */         loadFile(f);
/*     */       }
/* 207 */       FileOutputStream reportFile = new FileOutputStream("aop-report.xml");
/* 208 */       reportFile.write(XmlReport.toXml().getBytes());
/* 209 */       reportFile.close();
/*     */     }
/*     */     else
/*     */     {
/* 214 */       for (int i = 0; i < files.size(); i++)
/*     */       {
/* 216 */         File f = (File)files.get(i);
/* 217 */         if (f.isDirectory())
/*     */         {
/* 219 */           addDirectory(f);
/*     */         }
/* 221 */         else if (this.classFileFilter.accept(f))
/*     */         {
/* 223 */           addFile(f);
/*     */         }
/*     */         else
/*     */         {
/* 227 */           if (!this.verbose) continue; System.out.println("[aopc] " + f + " is neither a java class or a directory");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 232 */       for (it = this.classesToCompile.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 234 */         String className = (String)it.next();
/* 235 */         CompilerClassInfo info = (CompilerClassInfo)this.classesToCompile.get(className);
/* 236 */         compileFile(info);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addDirectory(File dir)
/*     */     throws Exception
/*     */   {
/* 245 */     File[] directories = dir.listFiles(this.directoryFilter);
/* 246 */     File[] classFiles = dir.listFiles(this.classFileFilter);
/* 247 */     for (int i = 0; i < classFiles.length; i++)
/*     */     {
/* 249 */       addFile(classFiles[i]);
/*     */     }
/* 251 */     for (int i = 0; i < directories.length; i++)
/*     */     {
/* 253 */       addDirectory(directories[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addFile(File file)
/*     */     throws Exception
/*     */   {
/* 260 */     ClassFile cf = createClassFile(file);
/* 261 */     String className = cf.getName();
/* 262 */     String superClassName = cf.getSuperclass();
/* 263 */     CompilerClassInfo info = new CompilerClassInfo(file, className, superClassName);
/* 264 */     this.classesToCompile.put(className, info);
/*     */   }
/*     */ 
/*     */   private ClassFile createClassFile(File file) throws Exception {
/* 268 */     DataInputStream is = new DataInputStream(new FileInputStream(file));
/* 269 */     ClassFile cf = new ClassFile(is);
/* 270 */     is.close();
/* 271 */     return cf;
/*     */   }
/*     */ 
/*     */   private void addFilesFromSourcePathFile(ArrayList files, String sourcePathFile)
/*     */   {
/* 276 */     BufferedReader reader = null;
/*     */     try
/*     */     {
/* 280 */       reader = new BufferedReader(new FileReader(new File(sourcePathFile).getCanonicalFile()));
/*     */ 
/* 282 */       String fileName = reader.readLine();
/* 283 */       while (fileName != null)
/*     */       {
/* 285 */         files.add(new File(fileName).getCanonicalFile());
/* 286 */         fileName = reader.readLine();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 293 */         reader.close();
/*     */       }
/*     */       catch (IOException e1)
/*     */       {
/*     */       }
/* 298 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void loadFile(File file) throws Exception
/*     */   {
/* 304 */     DataInputStream is = new DataInputStream(new FileInputStream(file));
/* 305 */     ClassFile cf = new ClassFile(is);
/* 306 */     is.close();
/* 307 */     Class clazz = loader.loadClass(cf.getName());
/* 308 */     if (Advised.class.isAssignableFrom(clazz))
/*     */     {
/* 310 */       Field f = clazz.getDeclaredField("aop$classAdvisor$aop");
/* 311 */       f.setAccessible(true);
/* 312 */       f.get(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void compileFile(CompilerClassInfo info) throws Exception
/*     */   {
/* 318 */     if (info.isCompiled())
/*     */     {
/* 320 */       return;
/*     */     }
/*     */ 
/* 323 */     if (info.getSuperClassName() != null)
/*     */     {
/* 325 */       CompilerClassInfo superInfo = (CompilerClassInfo)this.classesToCompile.get(info.getSuperClassName());
/* 326 */       if (superInfo != null)
/*     */       {
/* 328 */         compileFile(superInfo);
/*     */       }
/*     */     }
/*     */ 
/* 332 */     URL classUrl = loader.getResource(info.getClassName().replace('.', '/') + ".class");
/* 333 */     if (classUrl == null)
/*     */     {
/* 335 */       System.out.println("[warning] Unable to find " + info.getFile() + " within classpath.  Make sure all transforming classes are within classpath.");
/* 336 */       return;
/*     */     }
/*     */ 
/* 339 */     File classUrlFile = new File(URLDecoder.decode(classUrl.getFile(), "UTF-8"));
/* 340 */     File infoFile = new File(URLDecoder.decode(info.getFile().toString(), "UTF-8"));
/*     */ 
/* 342 */     if (!classUrlFile.equals(infoFile))
/*     */     {
/* 344 */       System.out.println("[warning] Trying to compile " + info.getFile() + " and found it also within " + classUrl.getFile() + " will not proceed. ");
/* 345 */       return;
/*     */     }
/* 347 */     byte[] bytes = AspectManager.instance().transform(loader, info.getClassName(), null, null, null);
/* 348 */     if (bytes == null)
/*     */     {
/* 350 */       if (this.verbose) System.out.println("[no comp needed] " + info.getFile());
/* 351 */       return;
/*     */     }
/* 353 */     FileOutputStream os = new FileOutputStream(infoFile);
/* 354 */     os.write(bytes);
/* 355 */     os.close();
/* 356 */     info.setCompiled(true);
/* 357 */     if (this.verbose) System.out.println("[compiled] " + info.getFile()); 
/*     */   }
/*     */   private class CompilerClassInfo {
/*     */     File file;
/*     */     String className;
/*     */     String superClassName;
/*     */     boolean compiled;
/*     */ 
/*     */     CompilerClassInfo(File file, String className, String superClassName) {
/* 369 */       this.file = file;
/* 370 */       this.className = className;
/* 371 */       this.superClassName = superClassName;
/*     */     }
/*     */ 
/*     */     public File getFile()
/*     */     {
/* 376 */       return this.file;
/*     */     }
/*     */ 
/*     */     public boolean isCompiled()
/*     */     {
/* 381 */       return this.compiled;
/*     */     }
/*     */ 
/*     */     public void setCompiled(boolean compiled)
/*     */     {
/* 386 */       this.compiled = compiled;
/*     */     }
/*     */ 
/*     */     public String getClassName()
/*     */     {
/* 391 */       return this.className;
/*     */     }
/*     */ 
/*     */     public String getSuperClassName()
/*     */     {
/* 396 */       return this.superClassName;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.Compiler
 * JD-Core Version:    0.6.0
 */