/*    */ package org.jboss.aop.standalone;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.HashMap;
/*    */ import java.util.Iterator;
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ import java.util.StringTokenizer;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.AspectManager;
/*    */ 
/*    */ public class Package
/*    */   implements Serializable
/*    */ {
/*    */   static final long serialVersionUID = 6188655039267365373L;
/* 41 */   public HashMap advisors = new HashMap();
/* 42 */   public HashMap packages = new HashMap();
/*    */   public String name;
/*    */ 
/*    */   public Package(String name)
/*    */   {
/* 47 */     this.name = name;
/*    */   }
/*    */ 
/*    */   static void parse(Class clazz, Package root)
/*    */   {
/* 52 */     Advisor advisor = AspectManager.instance().findAdvisor(clazz);
/* 53 */     StringTokenizer tokenizer = new StringTokenizer(clazz.getName(), ".");
/* 54 */     while (tokenizer.hasMoreTokens())
/*    */     {
/* 56 */       String pkgName = tokenizer.nextToken();
/* 57 */       if (tokenizer.hasMoreTokens())
/*    */       {
/* 59 */         Package subpkg = (Package)root.packages.get(pkgName);
/* 60 */         if (subpkg == null)
/*    */         {
/* 62 */           subpkg = new Package(pkgName);
/* 63 */           root.packages.put(pkgName, subpkg);
/*    */         }
/* 65 */         root = subpkg;
/*    */       }
/*    */       else
/*    */       {
/* 69 */         root.advisors.put(pkgName, advisor);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public static Package aopClassMap()
/*    */   {
/* 76 */     Map advisors = AspectManager.instance().getAdvisors();
/* 77 */     Iterator it = advisors.keySet().iterator();
/* 78 */     Package root = new Package("classes");
/* 79 */     while (it.hasNext())
/*    */     {
/* 81 */       Class clazz = (Class)it.next();
/* 82 */       parse(clazz, root);
/*    */     }
/* 84 */     return root;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.Package
 * JD-Core Version:    0.6.0
 */