/*    */ package org.jboss.aop.util;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import java.lang.reflect.Method;
/*    */ import javassist.CtField;
/*    */ import javassist.CtMethod;
/*    */ 
/*    */ public class Advisable
/*    */ {
/*    */   public static boolean isAdvisable(CtMethod method)
/*    */   {
/* 45 */     return isAdvisableMethod(method.getModifiers(), method.getName());
/*    */   }
/*    */ 
/*    */   public static boolean isAdvisable(Method method)
/*    */   {
/* 50 */     return isAdvisableMethod(method.getModifiers(), method.getName());
/*    */   }
/*    */ 
/*    */   public static boolean isAdvisableMethod(int modifiers, String name)
/*    */   {
/* 55 */     return ((modifiers & 0x400) == 0) && ((modifiers & 0x100) == 0) && (!name.endsWith("$aop")) && (!name.equals("_getAdvisor")) && (!name.equals("_getClassAdvisor")) && (!name.equals("_getInstanceAdvisor")) && (!name.equals("_setInstanceAdvisor")) && (!name.equals("class$")) && (!name.equals(""));
/*    */   }
/*    */ 
/*    */   public static boolean isAdvisable(CtField field)
/*    */   {
/* 71 */     return isAdvisableField(field.getModifiers(), field.getName());
/*    */   }
/*    */ 
/*    */   public static boolean isAdvisable(Field field)
/*    */   {
/* 76 */     return isAdvisableField(field.getModifiers(), field.getName());
/*    */   }
/*    */ 
/*    */   public static boolean isAdvisableField(int modifiers, String name)
/*    */   {
/* 81 */     return ((modifiers & 0x10) == 0) && (!name.endsWith("$aop")) && (!name.equals("_instanceAdvisor")) && (!name.endsWith("$aop$mixin")) && (name.indexOf('$') == -1);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.Advisable
 * JD-Core Version:    0.6.0
 */