/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileReader;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javassist.bytecode.ClassFile;
/*     */ 
/*     */ public class ForceInterfaceToImplementAnnotation
/*     */ {
/*     */   static final String RETRO_ANNOTATION = "org/jboss/lang/Annotation";
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  51 */     if ((args.length == 0) || (args.length > 2))
/*     */     {
/*  53 */       System.out.println("Usage:\njava org.jboss.aop.util.ForceInterfaceToImplementAnnotation dir-with-classes [file-listing-classes]");
/*  54 */       return;
/*     */     }
/*     */ 
/*  57 */     String input = args.length == 1 ? "annotations.txt" : args[1];
/*  58 */     List classes = readClasses(input);
/*  59 */     if (classes != null)
/*     */     {
/*  61 */       weaveAnnotations(args[0], classes);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static List<String> readClasses(String input)
/*     */   {
/*  67 */     File file = new File(input);
/*  68 */     if (!file.exists())
/*     */     {
/*  70 */       System.out.println(input + " could not be found");
/*  71 */       return null;
/*     */     }
/*     */ 
/*  74 */     BufferedReader rdr = null;
/*     */     try
/*     */     {
/*  77 */       rdr = new BufferedReader(new FileReader(file));
/*  78 */       ArrayList classes = new ArrayList();
/*  79 */       String clazz = rdr.readLine();
/*  80 */       while (clazz != null)
/*     */       {
/*  82 */         classes.add(clazz);
/*  83 */         clazz = rdr.readLine();
/*     */       }
/*     */ 
/*  86 */       ArrayList localArrayList1 = classes;
/*     */       return localArrayList1;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  91 */       throw new RuntimeException(e);
/*     */     }
/*     */     finally
/*     */     {
/*  95 */       if (rdr != null)
/*     */       {
/*     */         try
/*     */         {
/*  99 */           rdr.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 103 */           throw new RuntimeException(e); } 
/*     */       }
/* 103 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   private static void weaveAnnotations(String directory, List<String> classes)
/*     */   {
/* 111 */     File dir = new File(directory);
/* 112 */     if (!dir.exists())
/*     */     {
/* 114 */       throw new RuntimeException(directory + " does not exist");
/*     */     }
/* 116 */     if (!dir.isDirectory())
/*     */     {
/* 118 */       throw new RuntimeException(directory + " is not a directory");
/*     */     }
/*     */ 
/* 121 */     for (String clazz : classes)
/*     */     {
/* 123 */       File fileToWeave = getFileToWeave(directory, clazz);
/* 124 */       if (!fileToWeave.exists())
/*     */       {
/* 126 */         System.out.println("Weaving skipped for " + clazz + ". Could not find file at " + fileToWeave);
/*     */       }
/*     */       else
/*     */       {
/* 130 */         weaveClass(fileToWeave);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static File getFileToWeave(String directory, String clazz)
/*     */   {
/* 138 */     directory = directory.replace('/', File.separatorChar);
/* 139 */     directory = directory.replace('\\', File.separatorChar);
/* 140 */     StringBuffer filename = new StringBuffer(directory);
/* 141 */     if (!directory.endsWith(File.separator))
/*     */     {
/* 143 */       filename.append(File.separatorChar);
/*     */     }
/*     */ 
/* 146 */     if (clazz.endsWith(".class"))
/*     */     {
/* 148 */       clazz = clazz.substring(0, clazz.length() - ".class".length());
/*     */     }
/* 150 */     clazz = clazz.replace('.', File.separatorChar);
/* 151 */     clazz = clazz.replace('/', File.separatorChar);
/* 152 */     clazz = clazz.replace('\\', File.separatorChar);
/* 153 */     filename.append(clazz);
/*     */ 
/* 155 */     filename.append(".class");
/*     */ 
/* 157 */     return new File(filename.toString());
/*     */   }
/*     */ 
/*     */   public static void weaveClass(File file)
/*     */   {
/* 162 */     System.out.println("* Weaving interface in " + file + " to be compatible as an annotation in javassist");
/* 163 */     ClassFile classFile = getClassFile(file);
/*     */ 
/* 165 */     if (!classFile.isInterface())
/*     */     {
/* 167 */       throw new RuntimeException(file + " does not contain an interface");
/*     */     }
/*     */ 
/* 170 */     String[] interfaces = classFile.getInterfaces();
/* 171 */     boolean implementsRetroAnnotation = false;
/* 172 */     for (String intf : interfaces)
/*     */     {
/* 174 */       if (!intf.equals("org/jboss/lang/Annotation"))
/*     */         continue;
/* 176 */       implementsRetroAnnotation = true;
/* 177 */       break;
/*     */     }
/*     */ 
/* 181 */     if (!implementsRetroAnnotation)
/*     */     {
/* 187 */       classFile.addInterface("org/jboss/lang/Annotation");
/* 188 */       writeClassFile(classFile, file);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static ClassFile getClassFile(File file)
/*     */   {
/* 194 */     DataInputStream in = null;
/*     */     try
/*     */     {
/* 197 */       in = new DataInputStream(new FileInputStream(file));
/* 198 */       ClassFile localClassFile = new ClassFile(in);
/*     */       return localClassFile;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 202 */       throw new RuntimeException(e);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 208 */         if (in != null)
/*     */         {
/* 210 */           in.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 215 */         throw new RuntimeException(e); } 
/* 215 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   private static void writeClassFile(ClassFile cf, File file)
/*     */   {
/* 222 */     DataOutputStream out = null;
/*     */     try
/*     */     {
/* 225 */       out = new DataOutputStream(new FileOutputStream(file));
/* 226 */       cf.write(out);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 230 */       throw new RuntimeException("Problems writing " + file, e);
/*     */     }
/*     */     finally
/*     */     {
/* 234 */       if (out != null)
/*     */       {
/*     */         try
/*     */         {
/* 238 */           out.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 242 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.ForceInterfaceToImplementAnnotation
 * JD-Core Version:    0.6.0
 */