/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ 
/*     */ public class ReflectToJavassist
/*     */ {
/*     */   public static CtClass classToJavassist(Class clazz)
/*     */     throws NotFoundException
/*     */   {
/*  48 */     ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
/*  49 */     CtClass ct = pool.get(clazz.getName());
/*  50 */     return ct;
/*     */   }
/*     */ 
/*     */   public static CtField fieldToJavassist(Field field) throws NotFoundException
/*     */   {
/*  55 */     return classToJavassist(field.getDeclaringClass()).getField(field.getName());
/*     */   }
/*     */ 
/*     */   public static CtConstructor constructorToJavassist(Constructor con) throws NotFoundException {
/*  59 */     Class clazz = con.getDeclaringClass();
/*  60 */     Class[] params = con.getParameterTypes();
/*  61 */     String[] strParams = new String[params.length];
/*  62 */     for (int i = 0; i < params.length; i++)
/*     */     {
/*  64 */       strParams[i] = simpleType(params[i]);
/*     */     }
/*  66 */     CtClass ct = classToJavassist(clazz);
/*     */ 
/*  68 */     CtConstructor[] methods = ct.getDeclaredConstructors();
/*  69 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  71 */       CtClass[] ctParams = methods[i].getParameterTypes();
/*  72 */       if (ctParams.length != params.length)
/*     */         continue;
/*  74 */       boolean found = true;
/*  75 */       for (int j = 0; j < ctParams.length; j++)
/*     */       {
/*  77 */         if (ctParams[j].getName().equals(strParams[j]))
/*     */           continue;
/*  79 */         found = false;
/*  80 */         break;
/*     */       }
/*     */ 
/*  83 */       if (found) return methods[i];
/*     */     }
/*     */ 
/*  86 */     return null;
/*     */   }
/*     */ 
/*     */   protected static String simpleType(Class type)
/*     */   {
/*  91 */     Class ret = type;
/*  92 */     if (ret.isArray())
/*     */     {
/*  94 */       Class arr = ret;
/*  95 */       String array = "";
/*  96 */       while (arr.isArray())
/*     */       {
/*  98 */         array = array + "[]";
/*  99 */         arr = arr.getComponentType();
/*     */       }
/* 101 */       return arr.getName() + array;
/*     */     }
/* 103 */     return ret.getName();
/*     */   }
/*     */ 
/*     */   public static CtMethod methodToJavassist(Method method) throws NotFoundException
/*     */   {
/* 108 */     Class clazz = method.getDeclaringClass();
/* 109 */     Class[] params = method.getParameterTypes();
/* 110 */     String[] strParams = new String[params.length];
/* 111 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 113 */       strParams[i] = simpleType(params[i]);
/*     */     }
/* 115 */     CtClass ct = classToJavassist(clazz);
/*     */ 
/* 117 */     while (!ct.getName().equals(clazz.getName()))
/*     */     {
/* 119 */       ct = ct.getSuperclass();
/*     */     }
/* 121 */     CtMethod[] methods = ct.getDeclaredMethods();
/*     */ 
/* 123 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 125 */       if (!methods[i].getName().equals(method.getName())) {
/*     */         continue;
/*     */       }
/* 128 */       CtClass[] ctParams = methods[i].getParameterTypes();
/* 129 */       if (ctParams.length != params.length)
/*     */         continue;
/* 131 */       boolean found = true;
/* 132 */       for (int j = 0; j < ctParams.length; j++)
/*     */       {
/* 134 */         if (ctParams[j].getName().equals(strParams[j])) {
/*     */           continue;
/*     */         }
/* 137 */         found = false;
/* 138 */         break;
/*     */       }
/*     */ 
/* 141 */       if (found) return methods[i];
/*     */ 
/*     */     }
/*     */ 
/* 146 */     return null;
/*     */   }
/*     */ 
/*     */   public static String castInvocationValueToTypeString(Class type, String valueName)
/*     */   {
/* 163 */     String cast = null;
/* 164 */     if (type.isPrimitive())
/*     */     {
/* 166 */       if (type.equals(Boolean.TYPE))
/*     */       {
/* 168 */         cast = "((Boolean)" + valueName + ").booleanValue()";
/*     */       }
/* 170 */       else if (type.equals(Byte.TYPE))
/*     */       {
/* 172 */         cast = "((Byte)" + valueName + ").byteValue()";
/*     */       }
/* 174 */       else if (type.equals(Character.TYPE))
/*     */       {
/* 176 */         cast = "((Character)" + valueName + ").charValue()";
/*     */       }
/* 178 */       else if (type.equals(Double.TYPE))
/*     */       {
/* 180 */         cast = "((Double)" + valueName + ").doubleValue()";
/*     */       }
/* 182 */       else if (type.equals(Float.TYPE))
/*     */       {
/* 184 */         cast = "((Float)" + valueName + ").floatValue()";
/*     */       }
/* 186 */       else if (type.equals(Integer.TYPE))
/*     */       {
/* 188 */         cast = "((Integer)" + valueName + ").intValue()";
/*     */       }
/* 190 */       else if (type.equals(Long.TYPE))
/*     */       {
/* 192 */         cast = "((Long)" + valueName + ").longValue()";
/*     */       }
/* 194 */       else if (type.equals(Short.TYPE))
/*     */       {
/* 196 */         cast = "((Short)" + valueName + ").shortValue()";
/*     */       }
/*     */     }
/* 199 */     else if (type.isArray())
/*     */     {
/* 201 */       cast = "(" + type.getName() + ")" + valueName;
/*     */     }
/*     */     else
/*     */     {
/* 205 */       cast = "(" + type.getName() + ")" + valueName;
/*     */     }
/*     */ 
/* 208 */     return cast;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.ReflectToJavassist
 * JD-Core Version:    0.6.0
 */