/*    */ package org.jboss.aop.util.reference;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ 
/*    */ public class MethodPersistentReference extends ArgumentPersistentReference
/*    */ {
/*    */   String name;
/*    */ 
/*    */   public MethodPersistentReference(Method method, int referenceType)
/*    */   {
/* 36 */     super(method != null ? method.getDeclaringClass() : null, method, referenceType);
/* 37 */     if (method != null)
/*    */     {
/* 39 */       this.name = method.getName();
/* 40 */       setArguments(method.getParameterTypes());
/*    */     }
/*    */   }
/*    */ 
/*    */   public synchronized Object rebuildReference()
/*    */     throws Exception
/*    */   {
/* 49 */     Object returnValue = null;
/* 50 */     if ((returnValue = internalGet()) != null) return returnValue;
/*    */ 
/* 52 */     Method aMethod = getMappedClass().getDeclaredMethod(this.name, getArguments());
/* 53 */     buildReference(aMethod);
/* 54 */     return aMethod;
/*    */   }
/*    */ 
/*    */   public Method getMethod()
/*    */   {
/* 59 */     return (Method)get();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.reference.MethodPersistentReference
 * JD-Core Version:    0.6.0
 */