/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ 
/*    */ public class AsynchProxyInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -6294601804409518509L;
/*    */   private FutureHolder holder;
/*    */ 
/*    */   public AsynchProxyInterceptor(FutureHolder holder)
/*    */   {
/* 43 */     this.holder = holder;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 48 */     return "AsynchProxyInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 53 */     Object rtn = invocation.invokeNext();
/* 54 */     Future future = (Future)invocation.getResponseAttachment("ASYNCH_FUTURE");
/* 55 */     if (future != null)
/*    */     {
/* 57 */       this.holder.setFuture(future);
/*    */     }
/* 59 */     return rtn;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.AsynchProxyInterceptor
 * JD-Core Version:    0.6.0
 */