/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.aop.util.PayloadKey;
/*    */ 
/*    */ public class AsynchProxyMixin
/*    */   implements AsynchProvider, Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = -6895953696792282031L;
/*    */   public static final String CURRENT_FUTURE = "CURRENT_FUTURE";
/*    */   private transient ThreadLocal currentFuture;
/*    */   private InstanceAdvisor advisor;
/*    */ 
/*    */   public void setAdvisor(InstanceAdvisor advisor)
/*    */   {
/* 49 */     this.advisor = advisor;
/*    */   }
/*    */ 
/*    */   public void setFuture(Future future)
/*    */   {
/*    */     try
/*    */     {
/* 57 */       Future oldFuture = getFuture();
/* 58 */       if (oldFuture != null) oldFuture.release();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/*    */     }
/*    */ 
/* 64 */     this.currentFuture.set(future);
/*    */   }
/*    */ 
/*    */   public Future getFuture()
/*    */   {
/* 69 */     Future future = (Future)this.currentFuture.get();
/* 70 */     this.currentFuture.set(null);
/* 71 */     return future;
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out) throws IOException
/*    */   {
/* 76 */     out.writeObject(this.advisor);
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 81 */     this.advisor = ((InstanceAdvisor)in.readObject());
/* 82 */     this.currentFuture = new ThreadLocal();
/* 83 */     this.advisor.getMetaData().addMetaData("CURRENT_FUTURE", "CURRENT_FUTURE", this.currentFuture, PayloadKey.TRANSIENT);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.AsynchProxyMixin
 * JD-Core Version:    0.6.0
 */