/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ 
/*    */ public class FutureProxy
/*    */   implements Future
/*    */ {
/*    */   private Future delegate;
/* 35 */   private boolean released = false;
/*    */ 
/*    */   public void setDelegate(Future delegate)
/*    */   {
/* 39 */     synchronized (this)
/*    */     {
/* 41 */       this.delegate = delegate;
/* 42 */       if (this.released) delegate.release();
/* 43 */       notifyAll();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void release()
/*    */   {
/* 49 */     synchronized (this)
/*    */     {
/* 51 */       if (this.delegate == null)
/*    */       {
/* 53 */         this.released = true;
/* 54 */         return;
/*    */       }
/*    */     }
/* 57 */     this.delegate.release();
/*    */   }
/*    */ 
/*    */   public Object get() throws InterruptedException, InvocationTargetException
/*    */   {
/* 62 */     synchronized (this)
/*    */     {
/* 64 */       if (this.delegate == null)
/* 65 */         wait();
/* 66 */       if (this.delegate == null) throw new RuntimeException("Failed to get delegate and timed out");
/* 67 */       return this.delegate.get();
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object get(long milliseconds) throws TimeoutException, InterruptedException, InvocationTargetException
/*    */   {
/* 73 */     synchronized (this)
/*    */     {
/* 75 */       if (this.delegate == null)
/*    */       {
/* 77 */         wait(milliseconds);
/* 78 */         if (this.delegate == null) throw new TimeoutException("Failed to get delegate and timed out");
/*    */       }
/*    */     }
/* 81 */     return this.delegate.get(milliseconds);
/*    */   }
/*    */ 
/*    */   public boolean isDone()
/*    */   {
/* 86 */     return (this.delegate == null) || (this.delegate.isDone());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.FutureProxy
 * JD-Core Version:    0.6.0
 */