/*     */ package org.jboss.aspects.remoting;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.security.SecurityClientInterceptor;
/*     */ import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition;
/*     */ import org.jboss.ha.framework.server.HATarget;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ClusteredRemoting
/*     */   implements ClusterConstants
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(ClusteredRemoting.class);
/*     */ 
/*     */   public static ClassProxy clusterObject(Object objectId, Object obj, String partitionName, LoadBalancePolicy lb, InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/*  58 */     String proxyFamilyName = objectId.toString() + locator.getProtocol() + partitionName;
/*  59 */     HAPartition partition = (HAPartition)new InitialContext().lookup("/HAPartition/" + partitionName);
/*     */ 
/*  61 */     HATarget target = null;
/*  62 */     Map families = null;
/*  63 */     InstanceAdvisor advisor = null;
/*     */     Class clazz;
/*  66 */     if ((obj instanceof Advised))
/*     */     {
/*  68 */       advisor = ((Advised)obj)._getInstanceAdvisor();
/*  69 */       Class clazz = obj.getClass();
/*  70 */       Dispatcher.singleton.registerTarget(objectId, obj);
/*     */     }
/*     */     else
/*     */     {
/*  74 */       clazz = obj.getClass();
/*  75 */       ClassProxy proxy = ClassProxyFactory.newInstance(obj.getClass());
/*  76 */       advisor = proxy._getInstanceAdvisor();
/*  77 */       advisor.insertInterceptor(new ForwardingInterceptor(obj));
/*  78 */       Dispatcher.singleton.registerTarget(objectId, proxy);
/*     */     }
/*  80 */     families = (Map)advisor.getMetaData().getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILIES");
/*  81 */     if (families != null)
/*     */     {
/*  83 */       target = (HATarget)families.get(proxyFamilyName);
/*  84 */       if (target == null)
/*     */       {
/*  86 */         target = new HATarget(partition, proxyFamilyName, locator, 2);
/*  87 */         ClusteringTargetsRepository.initTarget(proxyFamilyName, target.getReplicants());
/*  88 */         families.put(proxyFamilyName, target);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  93 */       families = new HashMap();
/*  94 */       target = new HATarget(partition, proxyFamilyName, locator, 2);
/*  95 */       ClusteringTargetsRepository.initTarget(proxyFamilyName, target.getReplicants());
/*  96 */       families.put(proxyFamilyName, target);
/*  97 */       advisor.insertInterceptor(0, new ReplicantsManagerInterceptor(families));
/*     */     }
/*     */ 
/* 100 */     ClassProxy proxy = ClassProxyFactory.newInstance(clazz);
/* 101 */     InstanceAdvisor proxyAdvisor = proxy._getInstanceAdvisor();
/* 102 */     proxyAdvisor.insertInterceptor(IsLocalInterceptor.singleton);
/* 103 */     advisor.insertInterceptor(SecurityClientInterceptor.singleton);
/* 104 */     advisor.insertInterceptor(ClientTxPropagationInterceptor.singleton);
/* 105 */     proxyAdvisor.insertInterceptor(MergeMetaDataInterceptor.singleton);
/* 106 */     proxyAdvisor.insertInterceptor(ClusterChooserInterceptor.singleton);
/* 107 */     proxyAdvisor.insertInterceptor(InvokeRemoteInterceptor.singleton);
/*     */ 
/* 109 */     proxyAdvisor.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER", new FamilyWrapper(proxyFamilyName, target.getReplicants()), PayloadKey.AS_IS);
/*     */ 
/* 115 */     proxyAdvisor.getMetaData().addMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY", lb, PayloadKey.AS_IS);
/*     */ 
/* 120 */     proxyAdvisor.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/*     */ 
/* 125 */     proxyAdvisor.getMetaData().addMetaData("DISPATCHER", "OID", objectId, PayloadKey.AS_IS);
/*     */ 
/* 130 */     return proxy;
/*     */   }
/*     */ 
/*     */   public static void unregisterClusteredObject(Object object)
/*     */   {
/*     */     try
/*     */     {
/* 137 */       ClassProxy proxy = (ClassProxy)object;
/* 138 */       InstanceAdvisor advisor = proxy._getInstanceAdvisor();
/*     */ 
/* 140 */       String oid = (String)advisor.getMetaData().getMetaData("DISPATCHER", "OID");
/* 141 */       InstanceAdvised registeredObject = (InstanceAdvised)Dispatcher.singleton.getRegistered(oid);
/* 142 */       if (registeredObject == null) throw new NotRegisteredException(oid.toString() + " is not registered");
/* 143 */       Dispatcher.singleton.unregisterTarget(oid);
/*     */ 
/* 145 */       advisor = registeredObject._getInstanceAdvisor();
/* 146 */       Map families = (Map)advisor.getMetaData().getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILIES");
/* 147 */       Iterator it = families.values().iterator();
/* 148 */       while (it.hasNext())
/*     */       {
/* 150 */         HATarget target = (HATarget)it.next();
/* 151 */         target.destroy();
/*     */       }
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 156 */       log.trace("Ignored exception unregistering a clustered object", ignored);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.ClusteredRemoting
 * JD-Core Version:    0.6.0
 */