/*    */ package org.jboss.aspects.remoting;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.InvocationBase;
/*    */ import org.jboss.aop.metadata.MetaDataResolver;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.aop.metadata.ThreadMetaData;
/*    */ 
/*    */ public class MergeMetaDataInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 2424149906770308705L;
/* 41 */   public static final MergeMetaDataInterceptor singleton = new MergeMetaDataInterceptor();
/*    */ 
/* 43 */   public String getName() { return "MergeMetaDataInterceptor"; }
/*    */ 
/*    */   protected SimpleMetaData merge(Invocation invocation, MetaDataResolver resolver, SimpleMetaData merged)
/*    */   {
/* 47 */     if (resolver == null) return merged;
/* 48 */     SimpleMetaData metadata = resolver.getAllMetaData(invocation);
/* 49 */     if (metadata == null) return merged;
/* 50 */     if (merged == null)
/*    */     {
/* 52 */       merged = new SimpleMetaData();
/*    */     }
/* 54 */     merged.mergeIn(metadata);
/* 55 */     return merged;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 60 */     SimpleMetaData merged = null;
/* 61 */     merged = merge(invocation, ((InvocationBase)invocation).getInstanceResolver(), merged);
/*    */ 
/* 63 */     MetaDataResolver threadMetaData = ThreadMetaData.instance().getAllMetaData(invocation);
/* 64 */     merged = merge(invocation, threadMetaData, merged);
/*    */ 
/* 66 */     if (merged != null)
/*    */     {
/* 69 */       merged.mergeIn(invocation.getMetaData());
/*    */ 
/* 72 */       invocation.setMetaData(merged);
/*    */     }
/* 74 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.MergeMetaDataInterceptor
 * JD-Core Version:    0.6.0
 */